package com.bcxin.platform.domain.log;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 系统接口日志
 * 
 * @author zhangye
 * @since 2018-10-19 14:22:14
 */
@TableName("sys_interface_log")
@Data
public class SysInterfaceLog extends BaseEntity<SysInterfaceLog> {
	private static final long serialVersionUID = 231475054L;

	/** 接口日志ID */
	@ApiModelProperty(value = "接口日志ID")
	private Long interfaceLogId;

	/** 创建时间 */
	@ApiModelProperty(value = "创建时间")
	private Date createTime;

	/** 创建人ID */
	@ApiModelProperty(value = "创建人ID")
	private Long createBy;

	/** 接口类型 */
	@ApiModelProperty(value = "接口类型")
	private String interfaceType;

	/** 接口执行状态 */
	@ApiModelProperty(value = "接口执行状态")
	private String interfaceExecStatus;

	/** 执行开始时间 */
	@ApiModelProperty(value = "执行开始时间")
	private Date startTime;

	/** 执行结束时间 */
	@ApiModelProperty(value = "执行结束时间")
	private Date endTime;

	/** 接口请求数据 */
	@ApiModelProperty(value = "接口请求数据")
	private String parameters;

	/** 接口返回结果 */
	@ApiModelProperty(value = "接口返回结果")
	private String result;

	/** 接口提供平台ID */
	@ApiModelProperty(value = "接口提供平台ID")
	private Long providePlatId;

	/** 接口调用平台ID */
	@ApiModelProperty(value = "接口调用平台ID")
	private Long callPlatId;

	/** 接口访问地址 */
	@ApiModelProperty(value = "接口访问地址")
	private String url;

	/** 重复调用次数 */
	@ApiModelProperty(value = "重复调用次数")
	private Integer reExecCount;

}