package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 考勤打卡记录对象 tb_attend_clock
 * 
 * @author lin
 * @date 2021-08-27
 */
@Data
public class AttendClockDetail extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 打卡ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 排班ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="排班ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long schedulDetailId;

    /** 打卡定位经度 */
    private Double longitude;

    /** 打卡定位纬度 */
    private Double latitude;

    /** 打卡地址 */
    private String address;

    /** 打卡wifi名称 */
    private String wifiName;

    /** 打卡wifi设备mac地址 */
    private String wifiMac;

    /** 打卡时间 */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message="打卡时间不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Date clockTime;

    /** 打卡类型 1上班2下班*/
    //@NotBlank(message="打卡类型不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String clockType;

    /** 数据来源 1打卡2补卡*/
    @Excel(name = "数据来源")
    private String clockSource;

}
