package com.bcxin.platform.domain;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <b>任务残留表（当某方法回传数据给第三方时未成功传递的单子会在当前表记录，用于定时器多次尝试回传如果传递成功，则成功的记录会销毁） </b>
 *
 * @author zxf
 * @注意事项 </b>
 * <b>
 */
@Data
@TableName("com_task_residual")
public class ComTaskResidual extends BaseEntity<ComTaskResidual> {

    @ApiModelProperty(value = "主键")
    private Long com_task_residual_id;
    /**    方法名     */
    @ApiModelProperty(value = "方法名")
    private String method_name;
    /**    注释     */
    @ApiModelProperty(value = "注释")
    private String annotation;
    /**    类全称     */
    @ApiModelProperty(value = "类全称")
    private String class_name;
    /**    参数个数     */
    @ApiModelProperty(value = "参数个数")
    private int param_num = 0;
    /**    参数类型数组     */
    @ApiModelProperty(value = "参数类型数组")
    private String param_type_arr;
    /**    参数值数组     */
    @ApiModelProperty(value = "参数值数组")
    private String param_value_arr;
    /**    是否夜间执行     */
    @ApiModelProperty(value = "是否夜间执行")
    private String is_nightly_run = "0";

    public ComTaskResidual(){}

    public ComTaskResidual(Long com_task_residual_id,String method_name, String annotation, String class_name, int param_num, String param_type_arr, String param_value_arr){
        this.method_name = method_name;
        this.annotation = annotation;
        this.class_name = class_name;
        this.param_num = param_num;
        this.param_type_arr = param_type_arr;
        this.param_value_arr = param_value_arr;
        this.com_task_residual_id = com_task_residual_id;
    }

    public ComTaskResidual(Long com_task_residual_id,String method_name, String annotation, String class_name, int param_num, String param_type_arr, String param_value_arr, String is_nightly_run){
        this.method_name = method_name;
        this.annotation = annotation;
        this.class_name = class_name;
        this.param_num = param_num;
        this.param_type_arr = param_type_arr;
        this.param_value_arr = param_value_arr;
        this.is_nightly_run = is_nightly_run;
        this.com_task_residual_id = com_task_residual_id;
    }
}