/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.oauth;

import com.bcxin.platform.util.ByteAndObject;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RedisUtil {
    @Resource
    protected RedisTemplate<String, Object> redisTemplate;
    public static final int CAHCETIME = 60;
    public static final int CAHCEHOUR = 3600;
    public static final int CAHCEDAY = 86400;
    public static final int CAHCEWEEK = 604800;
    public static final int CAHCEMONTH = 18144000;
    @Value(value="${spring.redisPrefixKey}")
    public String REDIS_PREFIX_KEY = "PASP";

    protected RedisSerializer<String> getRedisSerializer() {
        return this.redisTemplate.getStringSerializer();
    }

    public boolean putCache(String key, Object value, final int seconds) {
        final byte[] bkey = (this.REDIS_PREFIX_KEY + ":" + key).getBytes();
        final byte[] bvalue = ByteAndObject.ObjectToByte(value);
        boolean result = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                if (seconds == 0) {
                    return connection.setNX(bkey, bvalue);
                }
                connection.setNX(bkey, bvalue);
                return connection.expire(bkey, TimeUnit.SECONDS.toSeconds(seconds));
            }
        });
        return result;
    }

    public Object getCache(final String key) {
        if (key == null) {
            return null;
        }
        byte[] result = (byte[])this.redisTemplate.execute((RedisCallback)new RedisCallback<byte[]>(){

            public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.get((RedisUtil.this.REDIS_PREFIX_KEY + ":" + key).getBytes());
            }
        });
        if (result == null) {
            return null;
        }
        Object obj = ByteAndObject.ByteToObject(result);
        return obj;
    }

    public Long delete(String key) {
        final byte[] bkey = (this.REDIS_PREFIX_KEY + ":" + key).getBytes();
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.del((byte[][])new byte[][]{bkey});
            }
        });
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean putStringCache(String key, String value, final int seconds) {
        final byte[] bkey = (this.REDIS_PREFIX_KEY + ":" + key).getBytes();
        final byte[] bvalue = value.getBytes();
        boolean result = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                if (seconds == 0) {
                    return connection.setNX(bkey, bvalue);
                }
                connection.setNX(bkey, bvalue);
                return connection.expire(bkey, TimeUnit.SECONDS.toSeconds(seconds));
            }
        });
        return result;
    }

    public String getStringCache(final String key) {
        String obj = null;
        try {
            if (key == null) {
                return null;
            }
            byte[] result = (byte[])this.redisTemplate.execute((RedisCallback)new RedisCallback<byte[]>(){

                public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                    return connection.get((RedisUtil.this.REDIS_PREFIX_KEY + ":" + key).getBytes());
                }
            });
            if (result == null) {
                return null;
            }
            obj = new String(result, "GB2312");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public boolean putListCache(String key, List<?> list, final int seconds) {
        final byte[] bkey = (this.REDIS_PREFIX_KEY + ":" + key).getBytes();
        final byte[] bvalue = ByteAndObject.serializeList(list);
        boolean result = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                if (seconds == 0) {
                    return connection.setNX(bkey, bvalue);
                }
                connection.setNX(bkey, bvalue);
                return connection.expire(bkey, TimeUnit.SECONDS.toSeconds(seconds));
            }
        });
        return result;
    }

    public List<?> getListCache(final String key) {
        if (key == null) {
            return null;
        }
        byte[] result = (byte[])this.redisTemplate.execute((RedisCallback)new RedisCallback<byte[]>(){

            public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.get((RedisUtil.this.REDIS_PREFIX_KEY + ":" + key).getBytes());
            }
        });
        if (result == null) {
            return null;
        }
        List<?> list = ByteAndObject.unserializeList(result);
        return list;
    }

    public boolean getRedisRepetition(String id) {
        Long count = this.redisTemplate.opsForValue().increment((Object)("repeat_submit:" + id), 1L);
        if (count == 1L) {
            this.redisTemplate.expire((Object)("repeat_submit:" + id), 5L, TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    public boolean setNx(String key, String value, long timeout) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
    }
}

