package com.bcxin.platform.mapper.wallet.manage;


import com.bcxin.platform.domain.wallet.PerWalletAccount;
import com.bcxin.platform.dto.SearchParamDTO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public interface PerWalletManageMapper {


    /**
     * <b> 个人钱包列表的分页查询 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:34
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pagePerWalletList(SearchParamDTO dto);


    /**
     * <b> 查询个人钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:33
     * @version
     * @注意事项 </b>
     */
    Map<String,Object> getPerWalletAccountByPerId(@Param("perId") Long perId);

    /**
     * <b> 更新个人钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:36
     * @version
     * @注意事项 </b>
     */
    int updatePerWalletAccount(PerWalletAccount perWalletAccount);

    /**
     * <b> 获取所有银行编码下拉数据 </b>
     * @author ZXF
     * @create 2019/09/02 0002 17:07
     * @version
     * @注意事项 </b>
     */
    List<Map> getAllBankCodeData();

    /**
     * <b> 根据个人钱包账户号查询个人名称 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:06
     * @version
     * @注意事项 </b>
     */
    String getPerNameByWalletNo(@Param("walletNo") String walletNo);
}