package com.bcxin.platform.mapper.grant;


import com.bcxin.platform.domain.grant.ComGrantRecord;
import com.bcxin.platform.domain.grant.ComGrantRecordDetail;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业发放记录
 *
 * @author llc
 * @date 2020-03-27
 */
public interface ComGrantRecordMapper {


    /**
     * 插入企业发放记录
     * @param comGrantRecord
     * @author llc
     * @date 2020-03-27
     */
    int insertComGrantRecord(ComGrantRecord comGrantRecord);


    /**
     * 更新企业发放记录
     * @param comGrantRecord
     * @author llc
     * @date 2020-03-27
     */
    int updateComGrantRecord(ComGrantRecord comGrantRecord);


    /**
     * 删除企业发放记录
     * @param comGrantRecord
     * @author llc
     * @date 2020-03-27
     */
    int deleteComGrantRecordById(ComGrantRecord comGrantRecord);

    /**
     * 获取企业发放记录列表
     * @param comGrantRecord
     * @author llc
     * @date 2020-03-27
     */
    List<Map<String, Object>> pageComGrantRecordList(ComGrantRecord comGrantRecord);

    /**
     * 插入发放明细
     * @param detailList
     * @return
     */
    int batchInsertRecordDetail(@Param("detailList") List<ComGrantRecordDetail> detailList);

}