package com.bcxin.platform.domain.wallet;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业钱包账户
 *
 * @author llc
 * @date 2019-06-20
 */
@Data
@TableName("com_wallet_account")
public class ComWalletAccount extends BaseEntity<ComWalletAccount> {

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String comName;

    /**
     * 富民企业类型
     */
    @ApiModelProperty(value = "富民企业类型")
    private String fmComType;

    /**
     * 企业证件类型
     */
    @ApiModelProperty(value = "企业证件类型")
    private String comCerType;

    /**
     * 企业证件号码
     */
    @ApiModelProperty(value = "企业证件号码")
    private String comCerNo;

    /**
     * 企业证件url
     */
    @ApiModelProperty(value = "企业证件url")
    private String comCerUrl;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话")
    private String contractPhone;

    /**
     * 企业经营地址
     */
    @ApiModelProperty(value = "企业经营地址")
    private String businessAddress;

    /**
     * 法定代表人姓名
     */
    @ApiModelProperty(value = "法定代表人姓名")
    private String legalRepName;

    /**
     * 法定代表人证件类型
     */
    @ApiModelProperty(value = "法定代表人证件类型：0身份证 1护照")
    private String idCardType;

    /**
     * 法定代表人证件号码
     */
    @ApiModelProperty(value = "法定代表人证件号码")
    private String idCardNo;

    /**
     * 法人手机号
     */
    @ApiModelProperty(value = "法人手机号")
    private String legalRepPhone;

    /**
     * 法人常住地址
     */
    @ApiModelProperty(value = "法人常住地址")
    private String legalRepPlace;

    /**
     * 身份证正面url
     */
    @ApiModelProperty(value = "身份证正面url")
    private String idCardFrontUrl;

    /**
     * 身份证反面url
     */
    @ApiModelProperty(value = "身份证反面url")
    private String idCardReverseUrl;

    /**
     * 身份证有效期开始日期
     */
    @ApiModelProperty(value = "身份证有效期开始日期")
    private String idCardStartDate;

    /**
     * 身份证有效期截止日期
     */
    @ApiModelProperty(value = "身份证有效期截止日期")
    private String idCardEndDate;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    private String mobilePhone;

    /**
     * 银行编码
     */
    @ApiModelProperty(value = "银行编码")
    private String bankCode;

    /**
     * 银行卡号
     */
    @ApiModelProperty(value = "银行卡号")
    private String bankCardNo;

    /**
     * 股东信息
     */
    @ApiModelProperty(value = "股东信息")
    private String shareholderInfo;

    /**
     * 受益人信息
     */
    @ApiModelProperty(value = "受益人信息")
    private String beneficiaryInfo;

    /**
     * 钱包账户号
     */
    @ApiModelProperty(value = "钱包账户号")
    private String walletAccountNo;

    /**
     * 冻结金额
     */
    @ApiModelProperty(value = "冻结金额")
    private String frozenAmount;

    /**
     * 工行保证支付财智卡号
     */
    @ApiModelProperty(value = "工行保证支付财智卡号")
    private String cardnoGS;

}