package com.bcxin.platform.domain.grant;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业渤海账户
 * 
 * @author llc
 * @date 2020-08-11
 */
@Data
@TableName("com_bh_account")
public class ComBhAccount extends BaseEntity<ComBhAccount> {

	/** 公司名称 */
	@ApiModelProperty(value = "公司名称")
	private String comName;

	/** 企业证件类型 */
	@ApiModelProperty(value = "企业证件类型")
	private String comCerType;

	/** 企业证件号码 */
	@ApiModelProperty(value = "企业证件号码")
	private String comCerNo;

	/** 企业证件url */
	@ApiModelProperty(value = "企业证件url")
	private String comCerUrl;

	/** 法定代表人姓名 */
	@ApiModelProperty(value = "法定代表人姓名")
	private String legalRepName;

	/** 法定代表人证件号码 */
	@ApiModelProperty(value = "法定代表人证件号码")
	private String idCardNo;

	/** 身份证正面url */
	@ApiModelProperty(value = "身份证正面url")
	private String idCardFrontUrl;

	/** 身份证反面url */
	@ApiModelProperty(value = "身份证反面url")
	private String idCardReverseUrl;

	/** 手机号 */
	@ApiModelProperty(value = "手机号")
	private String mobilePhone;

	/** 是否渤海银行 */
	@ApiModelProperty(value = "是否渤海银行")
	private String isBhBank ;

	/** 银行编码 */
	@ApiModelProperty(value = "银行编码")
	private String bankCode;

	/** 银行网点 */
	@ApiModelProperty(value = "银行网点")
	private String bankOutlets;

	/** 银行行号 */
	@ApiModelProperty(value = "银行行号")
	private String bankNo;

	/** 银行卡号 */
	@ApiModelProperty(value = "银行卡号")
	private String bankCardNo;

	/** 是否开通发薪权限 */
	@ApiModelProperty(value = "是否开通发薪权限")
	private String isOpenSalaryAuth;

	/** 渤海银行虚账号 */
	@ApiModelProperty(value = "渤海银行虚账号")
	private String bhVirlAcctNo;

}