package com.bcxin.platform.dto.oauth;


import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class AccessToken implements Serializable {

	private static final long serialVersionUID = -3065517831372557033L;

	public static final String BEARER_TYPE = "Bearer";

	// 过期刷新时间 60 * 60 * 2
	public static final int REFRESH_TOKEN_VALIDITY_SECONDS = 60 * 60 * 2; // default

	// WEB端生成ACCESS_TOKEN过期时间一天
	public static final int ACCESS_TOKEN_WEB_VALIDITY_SECONDS = 60 * 60 * 24; // WEB端登陆过期时间

	// 手机端生成ACCESS_TOKEN过期时间30天
	public static final int ACCESS_TOKEN_MOBILE_VALIDITY_SECONDS = 60 * 60 * 24 * 30;

	// ACCESS_TOKEN有效期小于10分钟时，用户有访问接口，则ACCESS_TOKEN有效期延长
	public static final int REFRESH_TOKEN_SECONDS = 10 * 60;

	protected static long THOUSAND = 1000L;

	private String tokenId;

	private String userId; // 账号id

	private String perId; // 用户id

	private String name; // 用户

	private String refreshToken;

	private String comId;// 公司ID

	private String tokenType = BEARER_TYPE;

	private int tokenExpiredSeconds;

	/**
	 * 创建时间, 默认为当前时间值
	 */
	protected Date createTime = new Date();

	/**
	 * 是否组织管理员
	 */
	private boolean domainAdmin = false;

	/**
	 * 管理部门id列表
	 */
	private String adminOrgIds;

	public AccessToken() {
	}

	public boolean tokenExpired() {
		final long time = createTime.getTime() + (this.tokenExpiredSeconds * THOUSAND);
		return time < System.currentTimeMillis();
	}

	public long currentTokenExpiredSeconds() {
		if (tokenExpired()) {
			return -1;
		}
		final long time = createTime.getTime() + (this.tokenExpiredSeconds * THOUSAND);
		return (time - System.currentTimeMillis()) / THOUSAND;
	}

}
