/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.quartz.controller;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.exception.job.TaskException;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.quartz.domain.SysJob;
import com.bcxin.platform.quartz.service.ISysJobService;
import com.bcxin.platform.quartz.util.CronUtils;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/monitor/job"})
public class SysJobController
extends BaseController {
    private String prefix = "monitor/job";
    @Autowired
    private ISysJobService jobService;

    @RequiresPermissions(value={"monitor:job:view"})
    @GetMapping
    public String job() {
        return this.prefix + "/job";
    }

    @RequiresPermissions(value={"monitor:job:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(SysJob job) {
        this.startPage();
        List<SysJob> list = this.jobService.selectJobList(job);
        return this.getDataTable(list);
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"monitor:job:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(SysJob job) {
        List<SysJob> list = this.jobService.selectJobList(job);
        ExcelUtil util = new ExcelUtil(SysJob.class);
        return util.exportExcel(list, "\u5b9a\u65f6\u4efb\u52a1");
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.DELETE)
    @RequiresPermissions(value={"monitor:job:remove"})
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) throws SchedulerException {
        this.jobService.deleteJobByIds(ids);
        return this.success();
    }

    @RequiresPermissions(value={"monitor:job:detail"})
    @GetMapping(value={"/detail/{jobId}"})
    public String detail(@PathVariable(value="jobId") Long jobId, ModelMap mmap) {
        mmap.put((Object)"name", (Object)"job");
        mmap.put((Object)"job", (Object)this.jobService.selectJobById(jobId));
        return this.prefix + "/detail";
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"monitor:job:changeStatus"})
    @PostMapping(value={"/changeStatus"})
    @ResponseBody
    public AjaxResult changeStatus(SysJob job) throws SchedulerException {
        SysJob newJob = this.jobService.selectJobById(job.getJobId());
        newJob.setStatus(job.getStatus());
        return this.toAjax(this.jobService.changeStatus(newJob));
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"monitor:job:changeStatus"})
    @PostMapping(value={"/run"})
    @ResponseBody
    public AjaxResult run(SysJob job) throws SchedulerException {
        this.jobService.run(job);
        return this.success();
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.INSERT)
    @RequiresPermissions(value={"monitor:job:add"})
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(@Validated SysJob job) throws SchedulerException, TaskException {
        if (!CronUtils.isValid(job.getCronExpression())) {
            return AjaxResult.error((String)"cron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
        }
        return this.toAjax(this.jobService.insertJob(job));
    }

    @GetMapping(value={"/edit/{jobId}"})
    public String edit(@PathVariable(value="jobId") Long jobId, ModelMap mmap) {
        mmap.put((Object)"job", (Object)this.jobService.selectJobById(jobId));
        return this.prefix + "/edit";
    }

    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"monitor:job:edit"})
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated SysJob job) throws SchedulerException, TaskException {
        if (!CronUtils.isValid(job.getCronExpression())) {
            return AjaxResult.error((String)"cron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
        }
        return this.toAjax(this.jobService.updateJob(job));
    }

    @PostMapping(value={"/checkCronExpressionIsValid"})
    @ResponseBody
    public boolean checkCronExpressionIsValid(SysJob job) {
        return this.jobService.checkCronExpressionIsValid(job.getCronExpression());
    }
}

