package com.bcxin.identify.util.getui;

/**
 * <b> 个推错误码参考枚举 </b>
 * @author ZXF
 * @create 2020/04/16 0016 16:09
 * @version
 * @注意事项 </b>
 */
public enum GTErrorEnum {

    ERROR_1("1", "失败，联系技术支持"),
    ERROR_2("2", "服务正在启动，请等待"),
    ERROR_301("301", "域名错误，请检查域名是否与appid机房匹配"),
    ERROR_404("404", "url错误，请检查Http路径是否正确"),
    ERROR_405("405", "方法不支持，该接口不支持该方法请求，请查看文档确认请求方式"),
    ERROR_10001("10001", "token错误/失效"),
    ERROR_10002("10002", "appId或ip在黑名单中"),
    ERROR_10003("10003", "每分钟鉴权频率超限"),
    ERROR_20001("20001", "参数不合法"),
    ERROR_22001("22001", "定时任务已经执行，无法删除"),
    ERROR_22002("22002", "任务无效或定时任务时间不合法"),
    ERROR_23001("23001", "操作tag失败"),
    ERROR_30000("30000", "没有推送fast_custom_tag的权限"),
    ERROR_30001("30001", "没有修改和删除custom_tag的权限"),
    ERROR_30002("30002", "没有推送定时任务的权限"),
    ERROR_30003("30003", "app/tag 接口无权限，或tag无效"),
    ERROR_30004("30004", "tag每日推送总数超限(VIP用户可根据应用特殊配置)"),
    ERROR_30005("30005", "tag长度超限(tag长度<32)"),
    ERROR_30006("30006", "fast_custom_tag次数超过每日推送总数限制(VIP用户可根据应用特殊配置)"),
    ERROR_30007("30007", "app/all推送，推送次数超过每日推送总数限制，每日最多推送100次"),
    ERROR_30008("30008", "list推送次数超过每日推送总数限制，每日最多推送2000000次"),
    ERROR_30009("30009", "推送次数超过每日推送总数限制"),
    ERROR_30010("30010", "app/tag 推送次数超过每日推送总数限制，每日最多推送100次，和接口app/all共享限制"),
    ERROR_30011("30011", "设置tag次数超过每日次数限制"),
    ERROR_30012("30012", "修改和删除tag 超过每分钟频率限制，每分钟最多操作5次"),
    ERROR_30013("30013", "推送fast_custom_tag频率超过每分钟频率限制(VIP用户可根据应用特殊配置)"),
    ERROR_30014("30014", "app 推送 频率超过每分钟频率限制，每分钟最多操作5次"),
    ERROR_30015("30015", "list推送 频率超过每分钟频率限制"),
    ERROR_30016("30016", "push/tag tag个数超过限制");

    private String error_code;

    private String error_msg;

    public String getError_code() {
        return error_code;
    }

    public String getError_msg() {
        return error_msg;
    }

    private GTErrorEnum(String error_code, String error_msg){
        this.error_code=error_code;
        this.error_msg=error_msg;
    }

    public static String errorMsg(String error_code){
        for(GTErrorEnum e : GTErrorEnum.values()){
            if(error_code.equals(e.getError_code())){
                return e.getError_msg();
            }
        }
        return "";
    }
}
