package com.bcxin.identify.util.baidu.v3;

/**
 * <b> 华为云会议错误码参考枚举 </b>
 * @author ZXF
 * @create 2020/04/16 0016 16:09
 * @version
 * @注意事项 </b>
 */
public enum BDErrorEnum {

    ERROR_000000001("Service temporarily unavailable", "服务暂不可用"),
    ERROR_000000002("Open api request limit reached", "集群超限额"),
    ERROR_000000003("no permission to access data", "没有接口权限"),
    ERROR_000000004("Open api daily request limit reached", "每天流量超限额"),
    ERROR_000000008("Open api qps request limit reached", "QPS超限额"),
    ERROR_000000010("Open api total request limit reached", "请求总量超限额"),
    ERROR_111070001("Invalid parameter", "无效的access_token参数"),
    ERROR_111070002("Access token invalid or no longer valid", "Access Token失效"),
    ERROR_111070003("Access token expired", "Access token过期"),
    ERROR_111070004("request body should be json format", "请求体中字段参数值数据类型与接口文档要求不符"),
    ERROR_111070005("param[image] format error", "参数格式错误"),
    ERROR_111070006("param[image_type] format error", "参数格式错误"),
    ERROR_111070007("param[quality_control] format error", "参数格式错误"),
    ERROR_111070008("param[liveness_control] format error", "参数格式错误"),
    ERROR_111070009("param[face_type] format error", "参数格式错误"),
    ERROR_111070010("param[face_sort_type] format error]", "参数格式错误"),
    ERROR_111070101("param[display_corp_image] format error", "参数格式错误"),
    ERROR_111071001("param[spoofing_control] format error", "参数格式错误"),
    ERROR_111071002("pic not has face", "图片中没有人脸"),
    ERROR_111071003("image check fail", "图片无法解析人脸"),
    ERROR_111071004("image download fail", "从图片的url下载图片失败"),
    ERROR_111071005("the number of image is incorrect", "请求体中图片数量不对"),
    ERROR_111071007("face token not exist", "face token不存在"),
    ERROR_111071008("get face fail", "获取人脸失败"),
    ERROR_111071011("image size is too large", "图片尺寸太大"),
    ERROR_111071013("face is covered", "人脸有被遮挡"),
    ERROR_111071014("face is fuzzy", "人脸模糊"),
    ERROR_111071052("face light is not good", "人脸光照不好"),
    ERROR_111071053("incomplete face", "人脸不完整"),
    ERROR_111071058("left eye is occlusion", "质量检测未通过，左眼遮挡程度过高"),
    ERROR_111071059("right eye is occlusion", "质量检测未通过，右眼遮挡程度过高"),
    ERROR_111071060("left cheek is occlusion", "质量检测未通过，左脸遮挡程度过高"),
    ERROR_111071063("right cheek is occlusion", "质量检测未通过，右脸遮挡程度过高"),
    ERROR_111071064("chin contour is occlusion", "质量检测未通过，下巴遮挡程度过高"),
    ERROR_111071065("nose is occlusion", "质量检测未通过，鼻子遮挡程度过高"),
    ERROR_111071066("mouth is occlusion", "质量检测未通过，嘴巴遮挡程度过高"),
    ERROR_111071067("face not forward", "人脸未面向正前方（人脸的角度信息超出限制）"),
    ERROR_111071069("the first image liveness check fail", "第一张图片人脸活体检测未通过"),
    ERROR_111071070("the second image liveness check fail", "第二张图片人脸活体检测未通过"),
    ERROR_111071071("the first image spoofing check fail", "第一张图片人脸合成图检测未通过"),
    ERROR_111071072("the second image spoofing check fail", "第二张图片人脸合成图检测未通过"),
    ERROR_111072001("system busy", "后端服务连接失败");

    private String error_code;

    private String error_msg;

    public String getError_code() {
        return error_code;
    }

    public String getError_msg() {
        return error_msg;
    }

    private BDErrorEnum(String error_code, String error_msg){
        this.error_code=error_code;
        this.error_msg=error_msg;
    }

    public static String errorMsg(String error_code){
        for(BDErrorEnum e : BDErrorEnum.values()){
            if(error_code.contains(e.getError_code())){
                return e.getError_msg();
            }
        }
        return "";
    }
}
