package com.bcxin.identify.util.baidu.ocr;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.bcxin.identify.util.Result;
import com.bcxin.identify.util.baidu.v3.HttpUtil;
import com.bcxin.identify.util.codes.CommonConst;
import com.bcxin.identify.util.common.StringUtil;
import com.bcxin.identify.util.sys.ConfigUtil;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/***
 * 百度
 */
public class IdcardAI {

    /***
     *  日志
     */
    private static final Logger logger = LoggerFactory.getLogger(IdcardAI.class);

	public static String idcardAI(String token, String param) {
		try {
			return HttpUtil.post(ConfigUtil.getValue(CommonConst.BAIDU_IDCARD_AI_URL), token, "application/x-www-form-urlencoded", param);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * <b> 身份证正反面比对 </b>
	 * @param token
	 * @param url 照片地址
	 * @param side front/back（front：身份证含照片的一面，back：身份证带国徽的一面）
	 * @author ZXF
	 * @create 2021/01/07 0007 14:37
	 * @version
	 * @注意事项 </b>
	 */
	public static Result idcard(String token, String url, String side) {
		String param = "id_card_side=" + side + "&url=" + url;
		String resultStr = idcardAI(token, param);
		if(StringUtil.isNotEmpty(resultStr)) {
			//json格式转换
			JSONObject data = JSONUtil.parseObj(resultStr);
			if (!"normal".equals(data.get("image_status"))) {
				return Result.fail(resultMsg(String.valueOf(data.get("image_status"))));
			}
			JSONObject res = JSONUtil.parseObj(data.get("words_result"));
			if(res==null){
				return Result.fail("未解析到合法身份证信息");
			}
			Map<String,String> map = Maps.newHashMap();
			if("front".equals(side)){
				JSONObject idCardNo = JSONUtil.parseObj(res.get("公民身份号码"));
				if(idCardNo!=null&&idCardNo.get("words")!=null){
					map.put("idCardNo",String.valueOf(idCardNo.get("words")));
				}
				JSONObject nativePlace = JSONUtil.parseObj(res.get("住址"));
				if(nativePlace!=null&&nativePlace.get("words")!=null){
					map.put("nativePlace",String.valueOf(nativePlace.get("words")));
				}
				JSONObject born = JSONUtil.parseObj(res.get("出生"));
				if(born!=null&&born.get("words")!=null){
					map.put("born",String.valueOf(born.get("words")));
				}
				JSONObject sex = JSONUtil.parseObj(res.get("性别"));
				if(sex!=null&&sex.get("words")!=null){
					map.put("sex",String.valueOf(sex.get("words")));
				}
				JSONObject national = JSONUtil.parseObj(res.get("民族"));
				if(national!=null&&national.get("words")!=null){
					map.put("national",String.valueOf(national.get("words")));
				}
			}else if("back".equals(side)){
				JSONObject issueDate = JSONUtil.parseObj(res.get("签发日期"));
				if(issueDate!=null&&issueDate.get("words")!=null){
					map.put("issueDate",String.valueOf(issueDate.get("words")));
				}
				JSONObject expiryDate = JSONUtil.parseObj(res.get("失效日期"));
				if(expiryDate!=null&&expiryDate.get("words")!=null){
					map.put("expiryDate",String.valueOf(expiryDate.get("words")));
				}
				JSONObject issuingAuthority = JSONUtil.parseObj(res.get("签发机关"));
				if(issuingAuthority!=null&&issuingAuthority.get("words")!=null){
					map.put("issuingAuthority",String.valueOf(issuingAuthority.get("words")));
				}
			}
			if(map.size()>0){
				return Result.success(Result.SUCCESS_QUERY_MSG,map);
			}
			return Result.fail("未解析到合法身份证信息");
		}
		return Result.fail("接口请求失败");
	}

	public static String resultMsg(String status){
		if("normal".equals(status)){
			return "识别正常";
		}else if("reversed_side".equals(status)){
			return "身份证正反面颠倒";
		}else if("non_idcard".equals(status)){
			return "上传的图片中不包含身份证";
		}else if("blurred".equals(status)){
			return "身份证模糊";
		}else if("other_type_card".equals(status)){
			return "其他类型证照";
		}else if("over_exposure".equals(status)){
			return "身份证关键字段反光或过曝";
		}else if("over_dark".equals(status)){
			return "身份证欠曝（亮度过低）";
		}else if("unknown".equals(status)){
			return "未知状态";
		}
		return "";
	}

	public static void main(String[] args) {
		String url = "http://bcxinsaasprod.baibaodun.cn/upload%2F2020-10-27%2F1603762307292760611.jpg";
		String token = "24.34fb3e478b5b04669a3c10a934d4465b.2592000.1612593016.282335-23500749";
		System.out.println(idcard(token, url, "front"));
	}
}