package com.bcxin.identify.business.service;

import cn.hutool.core.date.DateUtil;
import com.bcxin.identify.business.dao.LogBusinessrequestMapper;
import com.bcxin.identify.business.domain.LogBusinessrequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


@Service
@Transactional
@Slf4j
public class LogBusinessrequestService {
	
	@Autowired
	private LogBusinessrequestMapper logBusinessrequestMapper;
	
	
	/************ 查询，修改，保存相关 *********************/
	
	public LogBusinessrequest get(Long oid){
		return logBusinessrequestMapper.selectById(oid);
	}
	
	public void save(String businessType,String requestStatus,String request,String response){
		try {
			LogBusinessrequest log = new LogBusinessrequest();
			log.setBusinessType(businessType);
			log.setRequestStatus(requestStatus);
			log.setRequestMessage(request);
			log.setResponseMessage(response);
			log.setCreateOn(DateUtil.date());
			logBusinessrequestMapper.insert(log);
		} catch (Exception e){
			e.printStackTrace();
		}
	}

	public void saveOrUpdate(LogBusinessrequest log){
		if (log.getOid() != null ) {
			logBusinessrequestMapper.insert(log);
		} else {
			logBusinessrequestMapper.updateById(log);
		}
	}

	
}
