package com.bcxin.identify.api.yehuo.dto.request;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * description：野火获取用户token
 * author：linchunpeng
 * date：2023/10/16
 */
@Data
public class YehuoGetUserTokenRequest {

    //用户ID
    @NotBlank(message = "用户ID不能为空")
    private String userId;

    //客户端ID
    @NotBlank(message = "客户端ID不能为空")
    private String clientId;

    //平台类型iOS 1, Android 2, Windows 3, OSX 4, WEB 5, 小程序 6，linux 7
    @NotNull(message = "平台类型不能为空")
    private Integer platform;

    //身份证号
    @NotBlank(message = "身份证号不能为空")
    private String idNumber;

    //手机号码
    private String mobile;

    //姓名
    private String displayName;

}
