package com.bcxin.identify.api.huawei.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bcxin.identify.api.huawei.service.HuaweiMeetService;
import com.bcxin.identify.util.Result;
import com.bcxin.identify.util.common.JwtUtil;
import com.bcxin.identify.util.sys.ConfigUtil;
import io.jsonwebtoken.Claims;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * <b> 负责对外接口 </b>
 * @author ZXF
 * @create 2021/01/28 0028 13:20
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping("/identify/api/huawei")
@Slf4j
public class HuaweiController {

    @Resource
    private HuaweiMeetService huaweiMeetService;

    /**
     * <b> 获取企业华为云会议管理资源 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-huawei-manage-resource")
    @ResponseBody
    public Result getHuaweiManageResource(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/get-huawei-manage-resource】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiUserName"))
                || StrUtil.isEmpty(params.get("huaweiPassWord"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/get-huawei-manage-resource】华为云获取会议管理资源流程开始。");
        Result result = huaweiMeetService.getHuaweiManageResource(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/get-huawei-manage-resource】华为云获取会议管理资源流程结束。");
        return result;
    }

    /**
     * <b> 预约会议 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/build-huawei-meet")
    @ResponseBody
    public Result buildHuaweiMeet(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/build-huawei-meet】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiUserName"))
                || StrUtil.isEmpty(params.get("huaweiPassWord"))
                || StrUtil.isEmpty(params.get("restScheduleConf"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/build-huawei-meet】华为云预约会议流程开始。");
        Result result = huaweiMeetService.buildHuaweiMeet(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/build-huawei-meet】华为云预约会议流程结束。");
        return result;
    }

    /**
     * <b> 用户查询自己的信息 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-huawei-user-detail")
    @ResponseBody
    public Result getHuaweiUserDetail(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/get-huawei-user-detail】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiUserName"))
                || StrUtil.isEmpty(params.get("huaweiPassWord"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/get-huawei-user-detail】华为云用户查询自己的信息流程开始。");
        Result result = huaweiMeetService.buildHuaweiMeet(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/get-huawei-user-detail】华为云用户查询自己的信息流程结束。");
        return result;
    }

    /**
     * <b> 获取企业华为专用云会议室 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-huawei-cloud-meet-room-list")
    @ResponseBody
    public Result getHuaweiCloudMeetRoomList(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/get-huawei-cloud-meet-room-list】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiManageUserName"))
                || StrUtil.isEmpty(params.get("huaweiManagePassWord"))
                || StrUtil.isEmpty(params.get("offset"))
                || StrUtil.isEmpty(params.get("limit"))
//                || StrUtil.isEmpty(params.get("searchKey"))
                || StrUtil.isEmpty(params.get("status"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/get-huawei-cloud-meet-room-list】华为云获取企业专用云会议室流程开始。");
        Result result = huaweiMeetService.getHuaweiCloudMeetRoomList(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/get-huawei-cloud-meet-room-list】华为云获取企业专用云会议室流程结束。");
        return result;
    }

    /**
     * <b> 修改用户云会议室 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/update-huawei-cloud-member-vmr")
    @ResponseBody
    public Result updateHuaweiCloudMemberVmr(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/update-huawei-cloud-member-vmr】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiUserName"))
                || StrUtil.isEmpty(params.get("huaweiPassWord"))
                || StrUtil.isEmpty(params.get("vmrName"))
                || StrUtil.isEmpty(params.get("gustPwd"))
                || StrUtil.isEmpty(params.get("chairPwd"))
                || StrUtil.isEmpty(params.get("allowGustFirst"))
                || StrUtil.isEmpty(params.get("gustFirstNotice"))
                || StrUtil.isEmpty(params.get("vmrId"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/update-huawei-cloud-member-vmr】华为云修改用户云会议室流程开始。");
        Result result = huaweiMeetService.updateHuaweiCloudMemberVmr(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/update-huawei-cloud-member-vmr】华为云修改用户云会议室流程结束。");
        return result;
    }

    /**
     * <b> 回收专用云会议室 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/recycle-from-member")
    @ResponseBody
    public Result recycleFromMember(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/recycle-from-member】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiManageUserName"))
                || StrUtil.isEmpty(params.get("huaweiManagePassWord"))
                || StrUtil.isEmpty(params.get("account"))
                || StrUtil.isEmpty(params.get("vmrIds"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/recycle-from-member】华为云回收专用云会议室流程开始。");
        Result result = huaweiMeetService.recycleFromMember(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/recycle-from-member】华为云回收专用云会议室流程结束。");
        return result;
    }

    /**
     * <b> 分配专用云会议室 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/assign-to-member")
    @ResponseBody
    public Result assignToMember(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/assign-to-member】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiManageUserName"))
                || StrUtil.isEmpty(params.get("huaweiManagePassWord"))
                || StrUtil.isEmpty(params.get("account"))
                || StrUtil.isEmpty(params.get("vmrIds"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/assign-to-member】华为云分配专用云会议室流程开始。");
        Result result = huaweiMeetService.recycleFromMember(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/assign-to-member】华为云分配专用云会议室流程结束。");
        return result;
    }

    /**
     * <b> 删除专用云会议室 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/delete-member-vmr")
    @ResponseBody
    public Result deleteMemberVmr(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/delete-member-vmr】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiManageUserName"))
                || StrUtil.isEmpty(params.get("huaweiManagePassWord"))
                || StrUtil.isEmpty(params.get("account"))
                || StrUtil.isEmpty(params.get("vmrIds"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/delete-member-vmr】华为云删除专用云会议室流程开始。");
        Result result = huaweiMeetService.deleteMemberVmr(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/delete-member-vmr】华为云删除专用云会议室流程结束。");
        return result;
    }

    /**
     * <b> 分页查询用户云会议室 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-huawei-cloud-member-vmr-list")
    @ResponseBody
    public Result getHuaweiCloudMemberVmrList(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/get-huawei-cloud-member-vmr-list】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiUserName"))
                || StrUtil.isEmpty(params.get("huaweiPassWord"))
                || StrUtil.isEmpty(params.get("restScheduleConf"))
                || StrUtil.isEmpty(params.get("offset"))
                || StrUtil.isEmpty(params.get("limit"))
//                || StrUtil.isEmpty(params.get("searchKey"))
                || StrUtil.isEmpty(params.get("specialVmr"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/get-huawei-cloud-member-vmr-list】华为云分页查询用户云会议室流程开始。");
        Result result = huaweiMeetService.getHuaweiCloudMemberVmrList(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/get-huawei-cloud-member-vmr-list】华为云分页查询用户云会议室流程结束。");
        return result;
    }

    /**
     * <b> 华为云鉴权 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-huawei-access-token")
    @ResponseBody
    public Result getHuaweiAccessToken(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/get-huawei-access-token】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiUserName"))
                || StrUtil.isEmpty(params.get("huaweiPassWord"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/get-huawei-access-token】华为云鉴权流程开始。");
        Result result = huaweiMeetService.getHuaweiAccessToken(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/get-huawei-access-token】华为云鉴权流程结束。");
        return result;
    }

    /**
     * <b> 新增用户 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/add-user")
    @ResponseBody
    public Result addUser(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/add-user】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiManageUserName"))
                || StrUtil.isEmpty(params.get("huaweiManagePassWord"))
                || StrUtil.isEmpty(params.get("name"))
                || StrUtil.isEmpty(params.get("account"))
                || StrUtil.isEmpty(params.get("pwd"))
                || StrUtil.isEmpty(params.get("phone"))
                || StrUtil.isEmpty(params.get("sendNotify"))
                || StrUtil.isEmpty(params.get("country"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/add-user】华为云新增用户流程开始。");
        Result result = huaweiMeetService.addUser(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/add-user】华为云新增用户流程结束。");
        return result;
    }

    /**
     * <b> 批量删除用户 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/batch-delete-user")
    @ResponseBody
    public Result batchDeleteUser(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/batch-delete-user】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiManageUserName"))
                || StrUtil.isEmpty(params.get("huaweiManagePassWord"))
                || StrUtil.isEmpty(params.get("accounts"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/batch-delete-user】华为云批量删除用户流程开始。");
        Result result = huaweiMeetService.batchDeleteUser(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/batch-delete-user】华为云批量删除用户流程结束。");
        return result;
    }

    /**
     * <b> 华为云查询会议列表 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-huawei-meet-list")
    @ResponseBody
    public Result getHuaweiMeetList(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/get-huawei-meet-list】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiUserName"))
                || StrUtil.isEmpty(params.get("huaweiPassWord"))
                || StrUtil.isEmpty(params.get("userUUID"))
                || StrUtil.isEmpty(params.get("offset"))
                || StrUtil.isEmpty(params.get("limit"))
                || StrUtil.isEmpty(params.get("sortType"))
//                || StrUtil.isEmpty(params.get("searchKey"))
//                || StrUtil.isEmpty(params.get("queryConfMode"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/get-huawei-meet-list】华为云查询会议列表流程开始。");
        Result result = huaweiMeetService.getHuaweiMeetList(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/get-huawei-meet-list】华为云查询会议列表流程结束。");
        return result;
    }

    /**
     * <b> 获取录播文件列表 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-transcribe-file-list")
    @ResponseBody
    public Result getTranscribeFileList(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/get-transcribe-file-list】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiUserName"))
                || StrUtil.isEmpty(params.get("huaweiPassWord"))
                || StrUtil.isEmpty(params.get("userUUID"))
                || StrUtil.isEmpty(params.get("offset"))
                || StrUtil.isEmpty(params.get("limit"))
                || StrUtil.isEmpty(params.get("sortType"))
//                || StrUtil.isEmpty(params.get("searchKey"))
                || StrUtil.isEmpty(params.get("startTime"))
                || StrUtil.isEmpty(params.get("endTime"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/get-transcribe-file-list】华为云获取录播文件列表流程开始。");
        Result result = huaweiMeetService.getTranscribeFileList(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/get-transcribe-file-list】华为云获取录播文件列表流程结束。");
        return result;
    }

    /**
     * <b> 批量删除录播文件 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/batch-delete-transcribe-file")
    @ResponseBody
    public Result batchDeleteTranscribeFile(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/batch-delete-transcribe-file】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiUserName"))
                || StrUtil.isEmpty(params.get("huaweiPassWord"))
                || StrUtil.isEmpty(params.get("confUUIDs"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/batch-delete-transcribe-file】华为云批量删除录播文件流程开始。");
        Result result = huaweiMeetService.batchDeleteTranscribeFile(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/batch-delete-transcribe-file】华为云批量删除录播文件流程结束。");
        return result;
    }

    /**
     * <b> 查询会议详情 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-huawei-meet-detail")
    @ResponseBody
    public Result getHuaweiMeetDetail(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/huawei/get-huawei-meet-detail】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("huaweiUserName"))
                || StrUtil.isEmpty(params.get("huaweiPassWord"))
                || StrUtil.isEmpty(params.get("conferenceID"))
                || StrUtil.isEmpty(params.get("userUUID"))
//                || StrUtil.isEmpty(params.get("offset"))
//                || StrUtil.isEmpty(params.get("limit"))
//                || StrUtil.isEmpty(params.get("searchKey"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/huawei/get-huawei-meet-detail】华为云查询会议详情流程开始。");
        Result result = huaweiMeetService.getHuaweiMeetDetail(new HashMap<>(params));
        log.debug("接口【/identify/api/huawei/get-huawei-meet-detail】华为云查询会议详情流程结束。");
        return result;
    }
}
