export default {
  name: 'PlxRadio',
  props: {
    value: [String, Number],
    label: [String, Number],
    title: [String, Number],
    disabled: Boolean,
    name: String,
    size: String
  },
  computed: {
    vSize () {
      return this.size || this.$parent.size || this.$parent.vSize
    }
  },
  render (h) {
    let { $slots, disabled, title, vSize, value, label, name } = this
    let attrs = {}
    if (title) {
      attrs.title = title
    }
    return h('label', {
      class: ['plx-radio', {
        [`size--${vSize}`]: vSize,
        'is--disabled': disabled
      }],
      attrs
    }, [
      h('input', {
        attrs: {
          type: 'radio',
          name,
          disabled
        },
        domProps: {
          checked: value === label
        },
        on: {
          change: evnt => {
            if (!disabled) {
              this.$emit('input', label)
              this.$emit('change', label, evnt)
            }
          }
        }
      }),
      h('span', {
        class: 'plx-radio--icon'
      }),
      $slots.default ? h('span', {
        class: 'plx-radio--label'
      }, $slots.default) : null
    ])
  }
}
