package com.bcxin.runtime.domain.syncs.ftp;

import cn.hutool.core.util.StrUtil;
import com.bcxin.runtime.domain.syncs.dtos.FtpConfigInfoDto;
import com.bcxin.runtime.domain.syncs.entities.FileSyncQueueEntity;
import com.bcxin.runtime.domain.syncs.enums.UploadStatus;

import java.util.concurrent.Callable;

public class FtpUploadTask implements Callable {
    private FileSyncQueueEntity fileSyncQueueEntity;
    private FtpConfigInfoDto ftpConfigInfoDto;

    public FtpUploadTask(FileSyncQueueEntity fileSyncQueueEntit, FtpConfigInfoDto ftpConfigInfoDto) {
        this.fileSyncQueueEntity = fileSyncQueueEntit;
        this.ftpConfigInfoDto = ftpConfigInfoDto;
    }

    @Override
    public FileSyncQueueEntity call() throws Exception {
        try {
            String localPath = fileSyncQueueEntity.getDownloadUrl();
            String remotePath = fileSyncQueueEntity.getPath();
            remotePath = StrUtil.isEmpty(ftpConfigInfoDto.getFilePath()) ? remotePath : ftpConfigInfoDto.getFilePath() + remotePath;
            UploadStatus uploadStatus = FtpUtils.bcxUploadFile(ftpConfigInfoDto.getHost(),
                    ftpConfigInfoDto.getUserName(),
                    ftpConfigInfoDto.getPassword(),
                    ftpConfigInfoDto.getPort(),
                    remotePath,
                    localPath.substring(localPath.indexOf("path=")).replace("path=", ""));
            switch (uploadStatus) {
                case Create_Directory_Fail:
                    fileSyncQueueEntity.makeStatus(false, "远程服务器相应目录创建失败");
                    break;
                case Create_Directory_Success:
                    fileSyncQueueEntity.makeStatus(false, "远程服务器创建目录成功");
                    break;
                case Upload_New_File_Success:
                    fileSyncQueueEntity.makeStatus(true, "上传新文件成功");
                    break;
                case Upload_New_File_Failed:
                    fileSyncQueueEntity.makeStatus(false, "上传新文件失败");
                    break;
                case File_Exits:
                    fileSyncQueueEntity.makeStatus(true, "文件已经存在");
                    break;
                case File_Not_Exits:
                    fileSyncQueueEntity.makeStatus(false, "源文件不存在");
                    break;
                case Remote_Bigger_Local:
                    fileSyncQueueEntity.makeStatus(true, "远程文件大于本地文件");
                    break;
                case Upload_From_Break_Success:
                    fileSyncQueueEntity.makeStatus(true, "断点续传成功");
                    break;
                case Upload_From_Break_Failed:
                    fileSyncQueueEntity.makeStatus(false, "断点续传失败");
                    break;
                case Delete_Remote_Faild:
                    fileSyncQueueEntity.makeStatus(false, "删除远程文件失败");
                    break;
                default:
                    fileSyncQueueEntity.makeStatus(false, "");
            }
        } catch (Exception e) {
            StackTraceElement stackTrace = e.getStackTrace()[0];
            String message = "，类名："+stackTrace.getClassName() +"，方法名："+stackTrace.getMethodName()+"，报错行号："+stackTrace.getLineNumber();
            fileSyncQueueEntity.makeStatus(false, "异常：" +e.getMessage()+message);
        }
        return fileSyncQueueEntity;
    }
}
