package com.bcxin.runtime.domain.syncs.entities;

import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Date;
import java.util.UUID;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "sync_data_maps")
public class DataSyncMapEntity extends EntityBase<String> implements IAggregate {
    @Id
    private String id;
    @Column(name = "map_key",length = 200, nullable = false)
    private String mapKey;

    @Column(name = "target_config", nullable = false,length = 2000)
    private String targetConfig;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_updated_time", nullable = false)
    private Date lastUpdatedTime;
    @Column(name = "created_time", nullable = false)
    private Date createdTime;

    protected DataSyncMapEntity(){}

    protected DataSyncMapEntity(String mapKey, String targetConfig) {
        this.setId(UUID.randomUUID().toString());
        this.setMapKey(mapKey);
        this.setTargetConfig(targetConfig);
        this.setCreatedTime(new Date());
        this.setLastUpdatedTime(this.getCreatedTime());
    }

    public static DataSyncMapEntity create(String mapKey, String targetConfig) {
        return new DataSyncMapEntity(mapKey, targetConfig);
    }

    public void change(String mapKey, String targetConfig) {
        this.setLastUpdatedTime(new Date());
        this.setMapKey(mapKey);
        this.setTargetConfig(targetConfig);
    }
}
