package com.bcxin.runtime.domain.syncs.entities;

import com.bcxin.runtime.domain.syncs.enums.ProcessedStatus;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.models.EntityBase;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;
import java.util.UUID;

@Data
@Entity
@Table(name = "sync_data_request_logs")
public class DataSyncLogEntity extends EntityBase<String> implements IAggregate {
    @Id
    @Column(length = 100, nullable = false)
    private String id;
    @Column(name = "sync_queue_id", nullable = false)
    private String syncQueueId;
    @Column(length = 5000)
    private String data;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "created_time", nullable = false)
    private Date createdTime;

    //@Lob
    @Column(length = 5000)
    private String result;

    @Enumerated(EnumType.ORDINAL)
    @Column(nullable = false)
    private ProcessedStatus status;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "sync_data_map_id")
    private DataSyncMapEntity dataMapSync;

    /*
    @Column(name = "sync_data_map_id",length = 100)
    private String syncDataMapId;
     */

    protected DataSyncLogEntity(){}

    protected DataSyncLogEntity(DataSyncMapEntity dataMapSync, String syncQueueId,
                                String data, ProcessedStatus status, String  result) {
        this.setDataMapSync(dataMapSync);

        //this.setSyncDataMapId(dataMapSync.getId());
        this.setSyncQueueId(syncQueueId);
        this.setData(data);
        this.setStatus(status);
        this.setResult(result);
        this.setId(String.format("%s_%s", new Date().getTime(), UUID.randomUUID()));
        this.setCreatedTime(new Date());
    }

    public static DataSyncLogEntity create(DataSyncMapEntity dataMapSync, String syncQueueId,
                                           String data, ProcessedStatus status, String  result) {
        return new DataSyncLogEntity(dataMapSync, syncQueueId, data, status, result);
    }
}
