package com.bcxin.runtime.domain.syncs.commands.results;

import lombok.Getter;

import java.util.Collection;

@Getter
public class CreateDataSyncCommandResult {
    private final Collection<DataSetResult> dataSetResults;
    private final boolean savedFileQueued;

    public CreateDataSyncCommandResult(Collection<DataSetResult> dataSetResults,boolean savedFileQueued) {
        this.dataSetResults = dataSetResults;
        this.savedFileQueued = savedFileQueued;
    }

    public static CreateDataSyncCommandResult create(Collection<DataSetResult> dataSetResults,boolean savedFileQueued) {
        return new CreateDataSyncCommandResult(dataSetResults, savedFileQueued);
    }

    @Getter
    public static class DataSetResult {
        private final String dataSetId;
        private final boolean isSuccess;
        private final String result;

        public DataSetResult(String dataSetId, boolean isSuccess, String result) {
            this.dataSetId = dataSetId;
            this.isSuccess = isSuccess;
            this.result = result;
        }

        public static DataSetResult create(String dataSetId, boolean isSuccess, String result) {
            return new DataSetResult(dataSetId, isSuccess, result);
        }
    }
}
