package com.bcxin.runtime.domain.syncs.commands;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.google.common.io.Files;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

@Getter
public class CreateDataSyncCommand {
    private final Collection<DataSet> dataSets;
    private final String filePaths;
    private final Map<String, String> urlFilePathMappings;


    public CreateDataSyncCommand(Collection<DataSet> dataSets, String filePaths,Map<String, String> urlFilePathMappings) {
        this.dataSets = dataSets;
        this.filePaths = filePaths;
        this.urlFilePathMappings = urlFilePathMappings;
    }

    public String getDataSetId() {
        if (this.getDataSets() == null || this.getDataSets().isEmpty()) {
            return null;
        }

        return this.getDataSets().stream().map(ix -> ix.getId()).findFirst().get();
    }

    public String getOriginalDownloadUrl(String downloadUrl) {
        StringBuilder track = new StringBuilder(String.format("downloadUrl=%s;", downloadUrl));
        try {
            String mappingKey = downloadUrl;
            if (downloadUrl.contains("=")) {
                mappingKey = String.format("%s.%s", Files.getNameWithoutExtension(downloadUrl),Files.getFileExtension(downloadUrl));;
            }
            String originalDownloadUrl = this.getMatchKeyValue(mappingKey);
            /**
             * 不经过摆渡服务的话, 则downloadUrl地址为原始的地址
             */
            if (StringUtils.isEmpty(originalDownloadUrl)) {
                mappingKey = downloadUrl;
                originalDownloadUrl = this.getMatchKeyValue(mappingKey);//this.getUrlFilePathMappings().get(mappingKey);
            }

            //根据文件名获取地址
            if (StringUtils.isEmpty(originalDownloadUrl)) {
                int index =  downloadUrl.lastIndexOf("/");
                String fileName = downloadUrl.substring(index);
                Optional<String> keyOptional = this.getUrlFilePathMappings().keySet()
                        .stream().filter(ii -> ii.contains(fileName)).findFirst();
                if (keyOptional.isPresent()) {
                    mappingKey = keyOptional.get();
                }

                originalDownloadUrl = this.getMatchKeyValue(mappingKey);//this.getUrlFilePathMappings().get(mappingKey);
            }

            return originalDownloadUrl;
        } finally {

        }
    }

    private String getMatchKeyValue(String subKey) {
        if (this.getUrlFilePathMappings() == null) {
            return null;
        }

        Optional<String> keyOptional =
                this.getUrlFilePathMappings().keySet().stream().filter(ii -> ii.contains(subKey))
                        .findFirst();

        if (keyOptional.isPresent()) {
            return this.getUrlFilePathMappings().get(keyOptional.get());
        }

        return null;
    }

    public static CreateDataSyncCommand create(Collection<DataSet> dataSets, String filePaths,Map<String, String> urlFilePathMappings) {
        if(!StringUtils.isEmpty(filePaths) && CollectionUtil.isEmpty(urlFilePathMappings)) {
            throw new SaasBadException(String.format("数据格式无效(filePaths有值的时候, urlFilePathMappings不应该为空)!"));
        }

        return new CreateDataSyncCommand(dataSets, filePaths, urlFilePathMappings);
    }

    @Getter
    public static class DataSet {
        private final String id;
        private final String mapKey;
        private final Collection<DataSetDto.Row> rows;
        private final Collection<String> deletedIds;

        public DataSet(String id, String mapKey, Collection<DataSetDto.Row> rows,
                       Collection<String> deletedIds) {
            this.id = id;
            this.mapKey = mapKey;
            this.rows = rows;
            this.deletedIds = deletedIds;
        }

        public static DataSet create(String id, String mapKey, Collection<DataSetDto.Row> rows, Collection<String> deletedIds) {
            return new DataSet(id, mapKey, rows, deletedIds);
        }

        public String getAutoMapTableName(String regexDataMap) {
            /*
            Matcher matcher = Pattern.compile(regexDataMap).matcher(mapKey);
            if(!matcher.matches()) {
                return null;
            }

            return matcher.group(matcher.groupCount() - 1);

             */
            if(mapKey==null) {
                return null;
            }
            int lastSplitIndex = mapKey.lastIndexOf("|");
            if(lastSplitIndex<0) {
                return mapKey;
            }

            return mapKey.substring(lastSplitIndex+1);
        }
    }
}
