package com.bcxin.runtime.domain.snapshoots;

import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import lombok.Getter;
import lombok.Setter;

import java.util.Locale;

@Getter
@Setter
public class JdbcConnectionSnapshot {
    public static final String  MYSQL_PARSER_BEAN_NAME= "MySql_SqlParser";
    public static final String  POSTGRESQL_PARSER_BEAN_NAME= "PostgreSql_SqlParser";

    private String url;
    private String username;
    private String password;
    private String poolSize;
    private String driverClass;
    private String pathSuffix;
    private String path;
    private String urlPkgPrefixes;
    private String timeOut;


    public JdbcConnectionSnapshot(){}

    public static JdbcConnectionSnapshot create(String driverClass, String url, String username,
                                                String password, String poolSize,String pathSuffix,
                                                String path,String urlPkgPrefixes,String timeOut ) {
        JdbcConnectionSnapshot snapshot = new JdbcConnectionSnapshot();
        snapshot.setDriverClass(driverClass);
        snapshot.setUrl(url);
        snapshot.setUsername(username);
        snapshot.setPassword(password);
        snapshot.setPoolSize(poolSize);
        snapshot.setTimeOut(timeOut);
        snapshot.setPath(path);
        snapshot.setUrlPkgPrefixes(urlPkgPrefixes);
        snapshot.setPathSuffix(pathSuffix);

        return snapshot;
    }

    public String getSqlParserBeanName() {
        if (this.url.toLowerCase(Locale.ROOT).contains("mysql:")) {
            return MYSQL_PARSER_BEAN_NAME;
        } else if (this.url.toLowerCase(Locale.ROOT).contains("postgresql:")) {
            return POSTGRESQL_PARSER_BEAN_NAME;
        }

        return null;
    }
}
