package com.bcxin.runtime.domain.snapshoots;

import com.bcxin.runtime.domain.snapshoots.enums.SyncTargetType;
import com.bcxin.saas.core.enums.HttpMethod;
import lombok.Data;

import java.util.Map;

@Data
public class FormSyncTargetConfigSnapshot {
    private String url;
    private String fileUploadUrl;
    private HttpMethod method;
    private Map<String, Object> headers;
    private SyncTargetType targetType;
    private Map<String, Object> additionalData;

    public FormSyncTargetConfigSnapshot() {
    }

    public static FormSyncTargetConfigSnapshot create(SyncTargetType targetType, String url,
                                                      String fileUploadUrl, HttpMethod method, Map<String, Object> headers,
                                                      Map<String, Object> additionalData) {
        FormSyncTargetConfigSnapshot snapshot = new FormSyncTargetConfigSnapshot();
        snapshot.setTargetType(targetType);
        snapshot.setUrl(url);
        snapshot.setFileUploadUrl(fileUploadUrl);
        snapshot.setMethod(method);
        snapshot.setHeaders(headers);
        snapshot.setAdditionalData(additionalData);

        return snapshot;
    }
}
