package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.enums.HttpMethod;
import com.bcxin.saas.core.models.EntityBase;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "sync_meta_form_targets")
public class FormSyncTargetMetaEntity  extends EntityBase<String> implements IAggregate {
    @Id
    private String id;

    @Column(length = 500, nullable = false)
    private String url;

    @Enumerated
    @Column(nullable = false)
    private HttpMethod method;

    @Column(length = 500)
    private String note;
    //@Lob
    @Column(length = 5000)
    private String config;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "created_time")
    private Date createdTime;

    @OneToMany(mappedBy = "targetMetaEntity")
    public Collection<FormSyncMetaEntity> metaEntities;

    protected FormSyncTargetMetaEntity() {
        this.setCreatedTime(new Date());
    }

    public static FormSyncTargetMetaEntity create(
            String code,
            String url, HttpMethod method,
            String config, String note) {
        FormSyncTargetMetaEntity formSyncTargetMetaEntity = new FormSyncTargetMetaEntity();
        formSyncTargetMetaEntity.setId(code);
        formSyncTargetMetaEntity.setUrl(url);
        formSyncTargetMetaEntity.setMethod(method);
        formSyncTargetMetaEntity.setConfig(config);
        formSyncTargetMetaEntity.setNote(note);

        return formSyncTargetMetaEntity;
    }

    public void change(String url, HttpMethod method,String config, String note)
    {
        this.setUrl(url);
        this.setMethod(method);
        this.setConfig(config);
        this.setNote(note);
    }
}