package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.runtime.domain.metas.entities.enums.FormType;
import com.bcxin.saas.core.models.EntityBase;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import com.bcxin.runtime.domain.enums.BooleanStatus;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "meta_forms")
public class FormMetaEntity extends EntityBase<String> {
    @Id
    @Column(length = 50)
    private String id;
    @Column(nullable = false)
    private String name;
    @Column(length = 100,name = "table_name")
    private String tableName;

    @Column(name = "form_id", length = 50, nullable = false)
    private String formId;
    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    @JoinColumn(name = "application_meta_id")
    private ApplicationMetaEntity applicationMeta;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_updated_time")
    private Date lastUpdatedTime;

    @Column(nullable = false,columnDefinition = "smallint default 0",name = "form_type")
    @Enumerated(EnumType.ORDINAL)
    private FormType formType;

    @Column(nullable = false,columnDefinition = "bit default 0",name = "is_online")
    private BooleanStatus isOnline;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "created_time", nullable = false, columnDefinition = "DATETIME default current_timestamp()")
    private Date createdTime;

    @OneToMany(mappedBy = "formMeta",fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    private Collection<FormSyncMetaEntity> formSyncMetas;


    public void change(String name, String tableName,FormType formType) {
        this.setName(name);
        this.setTableName(tableName);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setFormType(formType);
    }

    public DataSourceMetaEntity getDefaultDataSource() {
        if(this.getApplicationMeta()==null || this.getApplicationMeta().getDataSourceMetas()==null) {
            return null;
        }

        Optional<DataSourceMetaEntity> dataSourceMetaEntityOptional = this.getApplicationMeta().getDataSourceMetas()
                .stream().filter(ii -> ii.getIsSelected()==BooleanStatus.TRUE).findFirst();

        if (dataSourceMetaEntityOptional.isPresent()) {
            return dataSourceMetaEntityOptional.get();
        }

        return null;
    }

    protected FormMetaEntity(){
        this.createdTime = new Date();
        this.lastUpdatedTime = this.createdTime;
        this.setIsOnline(BooleanStatus.FALSE);
    }

    protected FormMetaEntity(String id,String formId, String name,
                             String tableName,FormType formType) {
        this();
        this.setId(id);
        this.setName(name);
        this.setTableName(tableName);
        this.setFormId(formId);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setFormType(formType);
        this.setIsOnline(BooleanStatus.FALSE);
    }

    public static FormMetaEntity create(String formId, String name,
                                        String tableName, FormType formType) {
        return new FormMetaEntity(UUID.randomUUID().toString(), formId, name, tableName,formType);
    }
}
