package com.bcxin.runtime.domain.metas.entities;

import com.bcxin.runtime.domain.metas.entities.enums.*;
import com.bcxin.saas.core.models.EntityBase;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Date;
import java.util.UUID;
import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.runtime.domain.enums.BooleanStatus;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "meta_datasources")
public class DataSourceMetaEntity extends EntityBase<String> {
    @Id
    @Column(length = 100)
    private String id;
    @Column(length = 100, nullable = false,name = "data_source_id")
    private String dataSourceId;
    @Column(nullable = false)
    private String name;
    @Enumerated(EnumType.ORDINAL)
    @Column(nullable = false,name = "use_type")
    private UseType useType;
    @Enumerated(EnumType.ORDINAL)
    @Column(nullable = false,name = "db_type")
    private DbType dbType;

    @Setter
    @Column(nullable = false,name = "is_selected")
    private BooleanStatus isSelected;

    //@Lob
    @Column(nullable = true,length = 2000)
    private String config;
    private String note;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_updated_time")
    private Date lastUpdatedTime;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "created_time", nullable = false, columnDefinition = "DATETIME default current_timestamp()")
    private Date createdTime;

    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    @JoinColumn(name = "application_meta_id")
    private ApplicationMetaEntity applicationMeta;


    public void change(String name, UseType useType, DbType dbType, String config, String note) {
        this.setName(name);
        this.setDbType(dbType);
        this.setUseType(useType);
        this.setConfig(config);
        this.setNote(note);
        this.setLastUpdatedTime(lastUpdatedTime);
    }

    protected DataSourceMetaEntity() {
        this.createdTime = new Date();
        this.lastUpdatedTime = this.createdTime;
    }

    private DataSourceMetaEntity(String dataSourceId, String name, UseType useType, DbType dbType, String config, String note) {
        this();
        this.setId(UUID.randomUUID().toString());
        this.setDataSourceId(dataSourceId);
        this.setIsSelected(BooleanStatus.FALSE);
        this.change(name, useType, dbType, config, note);
    }

    public static DataSourceMetaEntity create(String dataSourceId, String name, UseType useType, DbType dbType, String config, String note) {
        return new DataSourceMetaEntity(dataSourceId,name, useType, dbType, config, note);
    }
}
