package com.bcxin.runtime.domain.metas.commands;

import com.bcxin.runtime.domain.snapshoots.enums.SyncTargetType;
import com.bcxin.saas.core.enums.HttpMethod;
import lombok.Getter;

import java.util.Collection;
import java.util.Map;

@Getter
public class RefreshFormSyncTargetMetaCommand {
    private final Collection<FormSyncTargetMeta> formSyncTargetMetas;

    public RefreshFormSyncTargetMetaCommand(Collection<FormSyncTargetMeta> formSyncTargetMetas) {
        this.formSyncTargetMetas = formSyncTargetMetas;
    }

    @Getter
    public static class FormSyncTargetMeta {
        private final String code;
        private SyncTargetType targetType;
        private final String url;
        private final String fileUploadUrl;
        private final HttpMethod method;
        private final Map<String, Object> headers;
        private final Map<String, Object> bodyAdditionalData;

        public FormSyncTargetMeta(String code,
                                  SyncTargetType targetType,
                                  String url,
                                  String fileUploadUrl,
                                  HttpMethod method,
                                  Map<String, Object> headers,
                                  Map<String, Object> bodyAdditionalData) {
            this.code = code;
            this.url = url;
            this.fileUploadUrl = fileUploadUrl;
            this.method = method;
            this.targetType = targetType;
            this.headers = headers;
            this.bodyAdditionalData = bodyAdditionalData;
        }

        public static FormSyncTargetMeta create(String code,
                                                SyncTargetType targetType,
                                                String url,
                                                String fileUploadUrl,
                                                HttpMethod method,
                                                Map<String, Object> headers,
                                                Map<String, Object> bodyAdditionalData) {
            return new FormSyncTargetMeta(code, targetType, url, fileUploadUrl, method, headers, bodyAdditionalData);
        }
    }
}
