package com.bcxin.runtime.domain.imports.commands;

import com.bcxin.runtime.domain.imports.entities.enums.ProcessedStatus;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import java.util.Collection;

@Getter
public class CreateDataImportCommandResult {
    private final Collection<SyncDocResponse> docResponses;

    public CreateDataImportCommandResult(Collection<SyncDocResponse> docResponses) {
        this.docResponses = docResponses;
    }

    public static CreateDataImportCommandResult create(Collection<SyncDocResponse> docResponses) {
        return new CreateDataImportCommandResult(docResponses);
    }

    @Getter
    @Setter(AccessLevel.PROTECTED)
    public static class SyncDocResponse
    {
        private final String eventId;
        private boolean isSuccess;
        private String message;

        public SyncDocResponse(String eventId,boolean isSuccess, String message) {
            this.eventId = eventId;
            this.isSuccess = isSuccess;
            this.message = message;
        }

        public void change(boolean isSuccess, String message) {
            this.isSuccess = isSuccess;
            this.setMessage(message);
        }

        public static SyncDocResponse create(String eventId,boolean isSuccess, String message) {
            return new SyncDocResponse(eventId, isSuccess, message);
        }
    }
}
