package com.bcxin.runtime.domain.imports.commands;

import lombok.Getter;

import java.util.Collection;
import java.util.Date;

@Getter
public class CreateDataImportCommand {
    private final Collection<SyncDocRequest> docRequests;

    public CreateDataImportCommand(Collection<SyncDocRequest> docRequests) {
        this.docRequests = docRequests;
    }

    public static CreateDataImportCommand create(Collection<SyncDocRequest> docRequests) {
        return new CreateDataImportCommand(docRequests);
    }

    @Getter
    public static class SyncDocRequest {
        private final String eventId;
        private final String appId;
        private final String formId;
        private final String body;
        private final Date businessDateTime;
        private final boolean focusToUpdate;
        private final SyncDocRequestAdditional additional;

        public SyncDocRequest(String eventId, String appId, String formId, String body,
                              Date businessDateTime, boolean focusToUpdate,SyncDocRequestAdditional additional) {
            this.eventId = eventId;
            this.appId = appId;
            this.formId = formId;
            this.body = body;
            this.businessDateTime = businessDateTime;
            this.additional = additional;
            this.focusToUpdate =focusToUpdate;
        }

        public static SyncDocRequest create(String eventId, String appId, String formId, String body,
                                            Date businessDateTime, boolean focusToUpdate, SyncDocRequestAdditional additional) {
            return new SyncDocRequest(eventId, appId, formId, body,
                    businessDateTime, focusToUpdate, additional);
        }
    }

    @Getter
    public static class SyncDocRequestAdditional {
        private final String regionId;
        private final DataSource source;
        private final DataSource target;
        private final String businessId;
        private final String businessType;
        private final String callbackUrl;
        private final String srcApp;
        private final String targetApp;
        private final String targetServiceUrl;

        public SyncDocRequestAdditional(String regionId, DataSource source, DataSource target,
                                        String businessId, String businessType, String callbackUrl, String srcApp,
                                        String targetApp, String targetServiceUrl) {
            this.regionId = regionId;
            this.source = source;
            this.target = target;
            this.businessId = businessId;
            this.businessType = businessType;
            this.callbackUrl = callbackUrl;
            this.srcApp = srcApp;
            this.targetApp = targetApp;
            this.targetServiceUrl = targetServiceUrl;
        }

        public static SyncDocRequestAdditional create(String regionId, DataSource source, DataSource target,
                                                      String businessId, String businessType, String callbackUrl, String srcApp,
                                                      String targetApp, String targetServiceUrl) {
            return new SyncDocRequestAdditional(regionId, source, target, businessId, businessType,
                    callbackUrl, srcApp, targetApp, targetServiceUrl);
        }
    }

    @Getter
    public static class SyncBodyRequest {
        private final String eventId;
        private final String regionId;
        private final DataSource source;
        private final DataSource target;
        private final String body;
        private final String businessId;
        private final String businessType;
        private final String callbackUrl;
        private final String srcApp;
        private final String targetApp;
        private final String targetServiceUrl;
        private final Date businessDateTime;

        public SyncBodyRequest(String eventId, String regionId, DataSource source,
                               DataSource target, String body,
                               String businessId, String businessType,
                               String callbackUrl, String srcApp, String targetApp,
                               String targetServiceUrl, Date businessDateTime) {
            this.eventId = eventId;
            this.regionId = regionId;
            this.source = source;
            this.target = target;
            this.body = body;
            this.businessId = businessId;
            this.businessType = businessType;
            this.callbackUrl = callbackUrl;
            this.srcApp = srcApp;
            this.targetApp = targetApp;
            this.targetServiceUrl = targetServiceUrl;
            this.businessDateTime = businessDateTime;
        }

        public static SyncBodyRequest create(String eventId, String regionId, DataSource source,
                                             DataSource target, String body,
                                             String businessId, String businessType,
                                             String callbackUrl, String srcApp, String targetApp,
                                             String targetServiceUrl, Date businessDateTime) {
            return new SyncBodyRequest(eventId, regionId, source, target, body, businessId, businessType,
                    callbackUrl, srcApp, targetApp, targetServiceUrl, businessDateTime);
        }
    }

    @Getter
    public static class DataSource
    {
        private final String userId;
        private final String appId;
        private final String formId;

        public DataSource(String userId, String appId, String formId) {
            this.userId = userId;
            this.appId = appId;
            this.formId = formId;
        }

        public static DataSource create(String userId, String appId, String formId) {
            return new DataSource(userId, appId, formId);
        }
    }
}
