package com.bcxin.runtime.domain.constants;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONValidator;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.google.common.io.Files;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;

@Slf4j
public class FieldNames {
    private static final Logger logger = LoggerFactory.getLogger(FieldNames.class);
    public static final Collection<String> ATTACHMENT_FILE_NAMES = new ArrayList<>();

    static {
        ATTACHMENT_FILE_NAMES.add("url");
        ATTACHMENT_FILE_NAMES.add("img");
        ATTACHMENT_FILE_NAMES.add("attachment");
        ATTACHMENT_FILE_NAMES.add("upload");
        ATTACHMENT_FILE_NAMES.add("photo");
        ATTACHMENT_FILE_NAMES.add("image");
        ATTACHMENT_FILE_NAMES.add("file");
        ATTACHMENT_FILE_NAMES.add("path");
        ATTACHMENT_FILE_NAMES.add("picture");
        ATTACHMENT_FILE_NAMES.add("pirture");
    }

    public static boolean isFile(String fieldName) {
        if (StringUtils.isEmpty(fieldName)) {
            return false;
        }

        return FieldNames.ATTACHMENT_FILE_NAMES.stream().anyMatch(ii -> fieldName.toLowerCase(Locale.ROOT).contains(ii));
    }

    public static boolean isFileIgnoreCase(String lowerFieldName) {
        if (StringUtils.isEmpty(lowerFieldName)) {
            return false;
        }

        return FieldNames.ATTACHMENT_FILE_NAMES.stream().anyMatch(ii -> lowerFieldName.contains(ii));
    }

    public static String formattedFileValue(
            String sitePrefix,
            String dId, String rowId, String value) {
        try {
            if (StringUtils.isEmpty(value)) {
                return value;
            }
            if (!value.contains("[")){
                String newValue = getPathString(value);
                return newValue;

            }

            List<PathOption> pathOptions = JSON.parseArray(value, PathOption.class);
            for (int index = 0; index < pathOptions.size(); index++) {
                PathOption pathOption = pathOptions.get(index);
                String originalPath =  pathOption.getPath();
                pathOption.setOriginalPath(originalPath);
                String fileName = null;
                if (!StringUtils.isEmpty(originalPath) && !"null".equalsIgnoreCase(originalPath)) {
                    String newPathValue = originalPath;
                    if(StringUtils.isNotEmpty(pathOption.getName())){
                        fileName = pathOption.getName();
                    }else {
                        fileName = String.format("%s.%s", Files.getNameWithoutExtension(originalPath), Files.getFileExtension(originalPath));
                    }
                    if (originalPath.toLowerCase(Locale.ROOT).startsWith("http")) {
                        if (originalPath.contains("/uploads")) {
                            newPathValue = originalPath.substring(originalPath.indexOf("/uploads"), originalPath.length());
                        } else if (originalPath.contains("/upload")) {
                            newPathValue = originalPath.substring(originalPath.indexOf("/upload"), originalPath.length()).replaceFirst("/upload", "/uploads");
                        } else {
                            String temPath = originalPath.replace("http://", "").replace("https://", "");
                            newPathValue = String.format("/uploads%s",
                                    temPath.substring(temPath.indexOf("/")));
                        }

                        if (newPathValue.contains("%2F")) {
                            newPathValue = newPathValue.replace("%2F", "/");
                        }
                    }

                    int indexSeparator = originalPath.lastIndexOf("/");
                    String fileName2 = originalPath.substring(indexSeparator + 1);
                    log.info("fileName2={}", fileName2);

                    String urlPathX = originalPath.substring(0, indexSeparator + 1);
                    log.info("urlPathX={}", urlPathX);

                    originalPath = String.format("%s/v2/sync/file/download?f=%s", sitePrefix, urlPathX + URLEncoder.encode(fileName2, "UTF-8"));
                    pathOption.setOriginalPath(originalPath);
                    pathOption.setPath(newPathValue);
                }

                if (StringUtils.isEmpty(fileName)) {
                    fileName = UUID.randomUUID().toString();
                }
                if (StringUtils.isEmpty(pathOption.getUid())) {
                    pathOption.setUid(rowId.concat(fileName));
                }
                pathOption.setName(fileName);
            }

            return JSON.toJSONString(pathOptions);
        } catch (Exception ex) {
            logger.error(String.format("格式化文件(%s)信息异常:%s", value, ExceptionUtils.getStackMessage(ex)));
        }

        return value;
    }
    private static String getPathString(String value) {
        String newValue = value;
        if (value.toLowerCase(Locale.ROOT).startsWith("http")) {
            if (value.contains("/uploads")) {
                newValue = value.substring(value.indexOf("/uploads"), value.length());
            } else if (value.contains("/upload")) {
                newValue = value.substring(value.indexOf("/upload"), value.length()).replaceFirst("/upload", "/uploads");
            } else {
                String temPath = value.replace("http://", "").replace("https://", "");
                newValue = String.format("/uploads%s",
                        temPath.substring(temPath.indexOf("/")));
            }
            if (newValue.contains("%2F")) {
                newValue = newValue.replace("%2F", "/");
            }
        }

        return newValue;
    }


    public static Collection<String> extractPathValues(String sitePrefix,String value) {
        if (StringUtils.isEmpty(value)) {
            return Collections.emptyList();
        }

        Collection<String> pathes = new ArrayList<>();
        try {
            if (JSON.isValid(value)) {
                List<PathOption> pathOptions = JSON.parseArray(value, PathOption.class);
                for (int index = 0; index < pathOptions.size(); index++) {
                    PathOption pathOption = pathOptions.get(index);
                    String originalPath = pathOption.getPath();
                    if (originalPath != null) {
                        if (!originalPath.startsWith("http")) {
                            originalPath = String.format("%s/obpm/%s", sitePrefix, originalPath).replace("//", "/");
                        }
                        pathes.add(originalPath);
                    }

                }
            } else {
                return Collections.singleton(value);
            }
        }
        catch (Exception ex) {
            pathes.add(String.format("%s;异常:%s", value, ex.getMessage()));
            System.err.println(String.format("当前的值为:%s;详细=%s", value, ExceptionUtils.getStackMessage(ex)));
            ex.printStackTrace();
        }

        return pathes;
    }

    @Data
    public static class PathOption {
        private String path;
        private String name;
        private String originalPath;
        private String size;
        private String uid;

        public PathOption() {
        }

        public static PathOption create(String name, String path, String originalPath, String size, String uid) {
            PathOption option = new PathOption();
            option.setName(name);
            option.setPath(path);
            option.setOriginalPath(originalPath);
            option.setSize(size);
            option.setUid(uid);
            return option;
        }
    }
}
