package com.bcxin.common.apis.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Collections;

@Component
public class JsonProviderImpl implements JsonProvider {
    @Override
    public <T> T getData(String json, Class<T> tClass) {
        try {
            return JSON.parseObject(json, tClass);
        } catch (Exception ex) {
            throw new SaasBadException("JSON反序列化异常", ex);
        }
    }

    @Override
    public <T> String getJson(T data) {
        try {
            return JSON.toJSONString(data, SerializerFeature.WriteDateUseDateFormat);
        } catch (Exception ex) {
            throw new SaasBadException("JSON序列化异常", ex);
        }
    }

    @Override
    public <T> Collection<T> getDataList(String json, Class<T> tClass) {
        if (!StringUtils.hasLength(json)) {
            return Collections.EMPTY_LIST;
        }

        return JSON.parseArray(json, tClass);
    }
}
