package com.bcxin.common.apis.configs;

import com.bcxin.event.repositories.EventSourceRepository;
import com.bcxin.event.repositories.repositories.JpaEventSourceRepository;
import com.bcxin.event.services.EventSourceService;
import com.bcxin.event.services.impls.EventSourceServiceImpl;
import com.bcxin.saas.core.components.JsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration("com.bcxin.common.apis.configs.SetupConfig")
@EnableJpaRepositories(basePackages = "com.bcxin.event.repositories.repositories")
@EntityScan(basePackages = "com.bcxin.event.entities")
public class CommonApiSetup {
    private static final Logger logger = LoggerFactory.getLogger(CommonApiSetup.class);
    @Bean
    public EventSourceRepository eventSourceRepository(JpaEventSourceRepository eventSourceRepository) {
        return eventSourceRepository;
    }

    @Bean
    public EventSourceService eventSourceService(JsonProvider jsonProvider,
                                                 EventSourceRepository eventSourceRepository) {
        return new EventSourceServiceImpl(jsonProvider, eventSourceRepository);
    }
}