package com.bcxin.web.commons;

import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * https://www.baeldung.com/exception-handling-for-rest-with-spring#spring-boot
 */
@Component
public class MyErrorController extends BasicErrorController {
    public MyErrorController(
            ErrorAttributes errorAttributes, ServerProperties serverProperties) {
        super(errorAttributes, serverProperties.getError());
    }

    @Override
    protected Map<String, Object> getErrorAttributes(HttpServletRequest request, ErrorAttributeOptions options) {
        Map<String, Object> map = super.getErrorAttributes(request, options);
        map.put("version", "v2");

        return map;
    }

    @Override
    protected boolean isIncludeStackTrace(HttpServletRequest request, MediaType produces) {
        return true || super.isIncludeStackTrace(request, produces);
    }

    @Override
    protected boolean isIncludeMessage(HttpServletRequest request, MediaType produces) {
        return true || super.isIncludeMessage(request, produces);
    }

    @Override
    protected boolean isIncludeBindingErrors(HttpServletRequest request, MediaType produces) {
        return true || super.isIncludeBindingErrors(request, produces);
    }
}
