package com.bcxin.web.commons.responses;

import com.bcxin.saas.core.utils.ExceptionUtils;
import lombok.Getter;
import lombok.Setter;

@Getter
public class ErrorResponse extends ResponseAbstract {
    private final boolean success;
    private final String message;
    @Setter
    private String detail;

    protected ErrorResponse(String message, boolean success) {
        this.success = success;
        this.message = message;
    }

    public static ErrorResponse create(Exception ex) {
        ErrorResponse errorResponse = new ErrorResponse("系统异常, 请及时联系管理员!", false);
        errorResponse.setDetail(ExceptionUtils.getStackMessage(ex));

        return errorResponse;
    }

    public static ErrorResponse create(String message, Exception ex) {
        ErrorResponse errorResponse = new ErrorResponse(message, false);
        errorResponse.setDetail(ExceptionUtils.getStackMessage(ex));

        return errorResponse;
    }
}
