package com.bcxin.spring.adpater.config;

import com.bcxin.saas.core.InjectResolver;
import com.bcxin.saas.core.InjectResolverFactory;
import com.bcxin.saas.core.components.*;
import com.bcxin.saas.domains.readers.*;
import com.bcxin.saas.domains.repositories.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;

@Configuration
@ComponentScan(basePackages = "com.bcxin.saas")
public class SaasSpringConfig implements ApplicationContextAware, ApplicationListener<ApplicationStartedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(SaasSpringConfig.class);
    @Bean
    public CacheProvider cacheProvider() {
        return CacheProviderFactory.getCacheProvider();
    }

    @Bean
    public DomainRelationDbReader domainRelationDbReader(
            DomainRelationRepository domainRelationRepository,
            CacheProvider cacheProvider) {
        return new DomainRelationDbReaderImpl(domainRelationRepository, cacheProvider);
    }

    @Bean
    public DepartmentDbReader departmentDbReader(DepartmentRepository departmentRepository) {
        return new DepartmentDbReaderImpl(departmentRepository);
    }

    @Bean
    public EmployeeDbReader employeeDbReader(EmployeeRepository employeeRepository) {
        return new EmployeeDbReaderImpl(employeeRepository);
    }

    @Bean
    public RbacDbReader rbacDbReader(DistributedCacheProvider distributedCacheProvider, RbacAppRepository rbacAppRepository, RbacOptionRepository rbacOptionRepository) {
        return new RbacDbReaderImpl(distributedCacheProvider,rbacAppRepository,rbacOptionRepository);
    }

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.applicationContext = appContext;
        InjectFactory.setApplicationContext(appContext);
        InjectResolverFactory.setInjectResolver(new InjectResolver() {
            @Override
            public <T> T resolve(Class<T> tClass) {
                return appContext.getBean(tClass);
            }

            @Override
            public <T> T resolve(String beanName) {
                return (T) appContext.getBean(beanName);
            }
        });
    }

    @Bean
    public EncryptProvider encryptProvider() {
        return new EncryptProvider.EncryptProviderImpl();
    }

    @Bean
    public JsonProvider jsonProvider() {
        return new JsonProvider.JsonProviderImpl();
    }

    @Bean
    public ClientAccessProvider clientAccessProvider(JsonProvider jsonProvider, EncryptProvider encryptProvider) {
        return new ClientAccessProvider.ClientAccessProviderImpl(jsonProvider, encryptProvider);
    }

    @Override
    public void onApplicationEvent(ApplicationStartedEvent event) {
        ClientAccessProvider clientAccessProvider = applicationContext.getBean(ClientAccessProvider.class);
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.YEAR, 50);
        Date expiredTime = calendar.getTime();
        //管理端
        String token = clientAccessProvider.createToken("Ai6hllhNjS2ull9TKGb", expiredTime);
        logger.error("管理端v2.App token:{}", token);

        String devToken = clientAccessProvider.createToken("__A7yVvj33RRHsOLgvt0d", expiredTime);
        logger.error("测试站点v2.yy_super.App token:{}", devToken);

        String prodToken = clientAccessProvider.createToken("__8Sprpm5xUGOiYzD0n61", expiredTime);
        logger.error("正式站点v2.yy_super.App token:{}", prodToken);

        System.err.println("V3.开始把System.err切换到Logger来实现");
        System.setErr(CustomSystemErrorPrintStream.instance);
    }

    private static class CustomSystemErrorPrintStream extends PrintStream {
        private static final Logger logger = LoggerFactory.getLogger(CustomSystemErrorPrintStream.class);
        private static CustomSystemErrorPrintStream instance = new CustomSystemErrorPrintStream(System.out);

        public CustomSystemErrorPrintStream(OutputStream out) {
            super(out);
        }

        @Override
        public void print(String s) {
            if (!FeatureOptionChecker.isEnable("ENABLE_PRINTED")) {
                return;
            }

            if (StringUtils.hasLength(s)) {
                logger.error(s);
            }
        }

        @Override
        public void println() {
            if (!FeatureOptionChecker.isEnable("ENABLE_PRINTED")) {
                return;
            }

            logger.error("\n");
        }

        @Override
        public void println(Object x) {
            if (!FeatureOptionChecker.isEnable("ENABLE_PRINTED")) {
                return;
            }
            super.println(x);
        }

        @Override
        public void println(String x) {
            if (!FeatureOptionChecker.isEnable("ENABLE_PRINTED")) {
                return;
            }

            super.println(x);
        }
    }
}