package com.bcxin.spring.adpater.config;
import org.springframework.context.ApplicationContext;

import java.io.Console;

public class InjectFactory {
    public static <T> T resolve(Class<T> tClass) {
        if (applicationContext == null) {
            System.err.println("applicationContext未进行初始化操作");
            return null;
        }

        return applicationContext.getBean(tClass);
    }

    private static ApplicationContext applicationContext;

    public static void setApplicationContext(ApplicationContext appContext) {
        InjectFactory.applicationContext = appContext;
    }
}
