package com.bcxin.saas.logging;

import com.alibaba.fastjson.JSON;
import com.bcxin.saas.core.components.FeatureOptionChecker;
import com.bcxin.saas.core.logs.LoggerEventMessage;
import com.bcxin.saas.core.logs.LoggerProvider;
import com.bcxin.saas.core.utils.ExceptionUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.UUID;


@Component
public class LoggerProviderImpl implements LoggerProvider {
    public static String JDBC_APPENDER_ENABLED_PRINT_FLAG="ENABLE_PRINTED";

    private final Logger logger = LoggerFactory.getLogger(LoggerProviderImpl.class);

    @Override
    public void append(LoggerEventMessage message) {
        /**
         * 当没有启动的时候, 不执行日志的记录
         */
        if(!FeatureOptionChecker.isEnable(JDBC_APPENDER_ENABLED_PRINT_FLAG)) {
            return;
        }
        String detailJson = null;
        try {
            detailJson = JSON.toJSONString(message.getParams());
        } catch (Exception ex) {
            detailJson = "数据序列化异常:" + ExceptionUtils.getStackMessage(ex);
        }

        try {
            ThreadContext.put("id", UUID.randomUUID().toString());
            ThreadContext.put("track_category", message.getCategory());
            ThreadContext.put("track_name", message.getName());
            ThreadContext.put("track_params", detailJson);
        } finally {
            ThreadContext.clearAll();
        }
    }

    @Override
    public void appends(Collection<LoggerEventMessage> messages) {
        if (CollectionUtils.isEmpty(messages)) {
            return;
        }

        messages.forEach(ms -> {
            this.append(ms);
        });
    }
}
