package com.bcxin.saas.domain.repositories;

import com.bcxin.saas.core.enums.OrganizationLevel;
import com.bcxin.saas.domains.dtos.EmployeeContextInfoDTO;
import com.bcxin.saas.domains.dtos.OrgContextInfoDTO;
import com.bcxin.saas.domains.repositories.TenantDbReaderRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Repository
public class TenantDbReaderRepositoryImpl implements TenantDbReaderRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public TenantDbReaderRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public EmployeeContextInfoDTO getByEmployeeId(String id) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("employeeId", id);
        String sql = "SELECT ee.id as employeeId,o.id,o.industry_code,o.institutional_code,o.`level`,o.supervise_region_code FROM tenant_employees ee join tenant_organizations o on ee.organization_id=o.id\n" +
                "where ee.id=:employeeId";
        return jdbcTemplate.query(
                sql,
                paramMap,
                resultSet -> {
                    Collection<EmployeeContextInfoDTO> rt = new ArrayList<>();
                    while (resultSet.next()) {
                        EmployeeContextInfoDTO info = new EmployeeContextInfoDTO();
                        info.setEmployeeId(resultSet.getString("employeeId"));
                        info.setId(resultSet.getString("id"));
                        info.setIndustryCode(resultSet.getString("industry_code"));
                        info.setInstitutionalCode(resultSet.getString("institutional_code"));
                        info.setSuperviseRegionCode(resultSet.getString("supervise_region_code"));
                        Collection<OrganizationLevel> selectedOrgLevels =
                                OrganizationLevel.getSelectedOrganizationLevels(resultSet.getInt("level"));

                        info.setOrganizationLevels(selectedOrgLevels);

                        rt.add(info);
                    }

                    return rt;
                }).stream().findFirst().orElse(null);
    }

    @Override
    public OrgContextInfoDTO getByOrgId(String orgId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("orgId", orgId);
        String sql = "SELECT o.id,o.industry_code,o.institutional_code,o.`level`,o.supervise_region_code FROM tenant_organizations o where o.id=:orgId";
        return jdbcTemplate.query(
                sql,
                paramMap,
                resultSet -> {
                    Collection<OrgContextInfoDTO> rt = new ArrayList<>();
                    while (resultSet.next()) {
                        OrgContextInfoDTO info = new OrgContextInfoDTO();
                        info.setId(resultSet.getString("id"));
                        info.setIndustryCode(resultSet.getString("industry_code"));
                        info.setInstitutionalCode(resultSet.getString("institutional_code"));
                        info.setSuperviseRegionCode(resultSet.getString("supervise_region_code"));
                        Collection<OrganizationLevel> selectedOrgLevels =
                                OrganizationLevel.getSelectedOrganizationLevels(resultSet.getInt("level"));

                        info.setOrganizationLevels(selectedOrgLevels);
                        rt.add(info);
                    }

                    return rt;
                }).stream().findFirst().orElse(null);
    }
}
