package com.bcxin.saas.domain.repositories;

import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.bcxin.saas.domains.entities.DomainRelationEntity;
import com.bcxin.saas.domains.repositories.DomainRelationRepository;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

import java.util.*;
import java.util.stream.Collectors;

@Repository
public class DomainRelationRepositoryImpl implements DomainRelationRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    public DomainRelationRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }


    @Override
    public Collection<DomainRelationEntity> getByDomainId(String domainId) {
        HashMap<String, String> param = new HashMap<>();
        param.put("domain_id", domainId);
        List<Map<String, Object>> maps =
                jdbcTemplate.queryForList("select * from saas_domain_relation where domain_id=:domain_id", param);

        return maps.stream().map(ii -> {
            DomainRelationEntity entity = new DomainRelationEntity();
            entity.setId((Integer) ii.get("id"));
            entity.setDomainId((String) ii.get("domain_id"));
            entity.setChildDomainId((String) ii.get("child_domain_id"));
            entity.setEnabled(((Integer) ii.get("is_enabled")==1));
            entity.setCreatedTime((Date) ii.get("created_time"));
            entity.setDomainId((String) ii.get("note"));


            return entity;
        }).collect(Collectors.toList());
    }

    @Override
    public <S extends DomainRelationEntity> List<S> saveAll(Iterable<S> entities) {
        throw new SaasNoSupportException();
    }
}
