package com.bcxin.saas.domain.repositories;

import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.bcxin.saas.domains.entities.DepartmentEntity;
import com.bcxin.saas.domains.repositories.DepartmentRepository;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DepartmentRepositoryImpl implements DepartmentRepository {

    private final NamedParameterJdbcTemplate jdbcTemplate;
    public DepartmentRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }



    @Override
    public DepartmentEntity getRootDepartmentByDomainId(String domainId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("domainId",domainId);
        return jdbcTemplate.queryForObject("select id,index_tree,name,parent_id,total_member from tenant_departments where organization_id=:domainId and status=1 and is_deleted=false and parent_id is null limit 1",paramMap,new BeanPropertyRowMapper<>(DepartmentEntity.class));
    }

    @Override
    public Collection<DepartmentEntity> getDepartmentByParentId(String parentId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("parentId",parentId);
        return jdbcTemplate.query("select id,index_tree,name,parent_id,total_member from tenant_departments where parent_id=:parentId and status=1 and is_deleted=false",paramMap,new BeanPropertyRowMapper<>(DepartmentEntity.class));
    }

    @Override
    public Collection<DepartmentEntity> getAllDepartmentByParentId(String parentId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("parentId",parentId);
        return jdbcTemplate.query("select id,index_tree,name,parent_id,total_member from tenant_departments where index_tree like':parentId-%' and status=1 and is_deleted=false",paramMap,new BeanPropertyRowMapper<>(DepartmentEntity.class));
    }


    @Override
    public <S extends DepartmentEntity> List<S> saveAll(Iterable<S> entities) {
        throw new SaasNoSupportException();
    }
}
