package com.bcxin.saas.core.utils;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class ThreadRequestUtil {
    private static WeakReference<ThreadLocal<Map<String,Object>>> _threadRequestContainer;
    private final static String IS_JUST_QUERY_COUNT_KEY="IS_JUST_QUERY_COUNT_KEY";
    public static void setIsJustQueryCount(boolean ignoredQueryData) {
        Map<String, Object> container = getThreadRequestContainer();

        container.put(IS_JUST_QUERY_COUNT_KEY, ignoredQueryData);

        storeThreadRequestContainer(container);
    }

    public static boolean getIsJustQueryCount() {
        Map<String, Object> container = getThreadRequestContainer();
        return container.containsKey(IS_JUST_QUERY_COUNT_KEY) &&
                (boolean) container.get(IS_JUST_QUERY_COUNT_KEY);
    }

    private static Map<String,Object> getThreadRequestContainer() {
        if (_threadRequestContainer == null || _threadRequestContainer.get() == null) {
            _threadRequestContainer = new WeakReference<ThreadLocal<Map<String, Object>>>(new ThreadLocal<>());
        }

        ThreadLocal<Map<String, Object>> threadLocal = _threadRequestContainer.get();
        Map<String, Object> container = threadLocal.get();
        if (container == null) {
            synchronized (ThreadRequestUtil.class) {
                container = threadLocal.get();
                if (container == null) {
                    container = new HashMap<>();

                    threadLocal.set(container);
                }
            }
        }

        return container;
    }


    private static void storeThreadRequestContainer(Map<String, Object> container) {
        if (_threadRequestContainer == null || _threadRequestContainer.get() == null) {
            _threadRequestContainer = new WeakReference<ThreadLocal<Map<String, Object>>>(new ThreadLocal<>());
        }

        _threadRequestContainer.get().set(container);
    }

    public static void setIsFeatureEnabled(String featureKey, boolean enable) {
        Map<String, Object> container = getThreadRequestContainer();

        container.put(featureKey, enable);

        storeThreadRequestContainer(container);
    }

    public static boolean getIsFeatureEnabled(String featureKey) {
        Map<String, Object> container = getThreadRequestContainer();
        return container.containsKey(featureKey) &&
                (boolean) container.get(featureKey);
    }

}
