package com.bcxin.saas.core.utils;

import cn.hutool.core.util.StrUtil;

import java.util.ArrayList;
import java.util.stream.Collectors;

public class ComponentUtils {
    private static ArrayList<String> staticResourceArray = new ArrayList();
    public final static String specialUploadPath = "/uploads/item/";
    static {
        staticResourceArray.add(".png");
        staticResourceArray.add("/v2/sync/");
        staticResourceArray.add(specialUploadPath);
        staticResourceArray.add("/obpm/magic-api/order/push");
        staticResourceArray.add("/api/caches/");
        staticResourceArray.add("/v2/sync/");
        staticResourceArray.add("/v3/extends/");
        staticResourceArray.add("/api/v2/runtime");
        staticResourceArray.add("/components/do-refresh");
        staticResourceArray.add("actuator/health");
        staticResourceArray.add("actuator/httptrace");
        staticResourceArray.add("actuator/metrics");
        staticResourceArray.add("/api/runtime/logout");
        staticResourceArray.add("/api/runtime/removeOnlineUser");
        staticResourceArray.add("/components/do-refresh");
    }

    public static boolean isFilterIgnored(String uri) {
        if (StrUtil.isBlank(uri)) {
            return false;
        }
        if (staticResourceArray.stream().anyMatch(ii -> {
            return StrUtil.containsAny(uri, ii);
        })) {
            return true;
        }

        return false;
    }

    public static String getExclusions() {
        return staticResourceArray.stream().map(ii -> String.format("*.%s", ii)).collect(Collectors.joining(","));
    }
}
