package com.bcxin.saas.core.logs;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.saas.core.InjectResolverFactory;
import com.bcxin.saas.core.components.SessionProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

import javax.sql.DataSource;
import java.sql.*;
import java.util.*;

public class SysLogProvider {
    public static final String DEBUG_SESSION = "DEBUG_SESSION";
    private static Logger logger = LoggerFactory.getLogger(SysLogProvider.class);

    private static String LOG_SQL_QUERY_CONTENT_SELECT_TEMPLATE="select ID,`TRACK_CATEGORY`,`TRACK_NAME`,`MESSAGE`,`TRACK_PARAMS` from logging_sys_apps x where x.TRACK_CATEGORY=?";
    private static String LOG_SQL_QUERY_CONTENT_DELETE_TEMPLATE="delete from logging_sys_apps where TRACK_CATEGORY=?";

    private static DataSource dataSource;
    public static void log(String category, String name,ProcessedStatus status,String message, Object data) {
        LoggerProvider loggerProvider = InjectResolverFactory.resolve(LoggerProvider.class);
        if (loggerProvider == null) {
            return;
        }

        loggerProvider.append(LoggerEventMessage.create(category, name, message, data, Level.ERROR));
    }

    public static void log(Collection<LoggerEventMessage> loggerEventMessages) {
        if (loggerEventMessages == null || loggerEventMessages.size() == 0) {
            return;
        }
        LoggerProvider loggerProvider = InjectResolverFactory.resolve(LoggerProvider.class);
        if (loggerProvider == null) {
            System.err.println("无法解析loggerProvider Bean对象");
            return;
        }

        loggerProvider.appends(loggerEventMessages);
    }

    public static Collection<LoggerEventMessage> getMessages(String categoryId) {
        Collection<LoggerEventMessage> result = new ArrayList<>();

        Object sessionValue = InjectResolverFactory.resolve(SessionProvider.class).getAttribute(DEBUG_SESSION);
        if (sessionValue != null) {
            result.addAll((Collection<LoggerEventMessage>) sessionValue);
        }

        return result;
    }

    public static void deleteMessages(String categoryId) {
        InjectResolverFactory.resolve(SessionProvider.class).setAttribute(DEBUG_SESSION, null);
    }

    public static void log(String category, String name,Exception ex) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("error", ExceptionUtils.getStackMessage(ex));

        log(category, name, ProcessedStatus.Error, ex.getMessage(), jsonObject);
    }


    public static void setDataSource(DataSource dataSource) {
        SysLogProvider.dataSource = dataSource;
    }

    public static enum ProcessedStatus {
        Initialize,
        Done,
        Processing,
        Error,
        Retry
    }
}
