package com.bcxin.saas.core.components.dtos;

import com.bcxin.saas.core.components.DataPermissionScopeConfig;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

@Getter
@Setter(AccessLevel.PRIVATE)
public class DataPermissionScopeDTO implements Serializable {
    private String id;
    private String searchIndexCode;
    private Collection<String> scopes;
    private boolean crossPermission;

    public DataPermissionScopeDTO() {
    }

    public static DataPermissionScopeDTO create(
            String id,
            String searchIndexCode,
            Collection<String> scopes,
            Collection<String> additionalScopes
    ) {
        DataPermissionScopeDTO dataPermissionScopeDTO = new DataPermissionScopeDTO();
        dataPermissionScopeDTO.setId(id);

        Collection<String> allowedScopes = new HashSet<>();
        if (scopes != null && !scopes.isEmpty()) {
            allowedScopes.addAll(scopes);
        }

        if (!DataPermissionScopeConfig.ALL_PERMISSIONS.equals(searchIndexCode)) {
            allowedScopes.add(id);
            allowedScopes.addAll(additionalScopes);
        }

        dataPermissionScopeDTO.setSearchIndexCode(searchIndexCode);
        dataPermissionScopeDTO.setScopes(allowedScopes);
        dataPermissionScopeDTO.setCrossPermission(allowedScopes.size() > 1);

        return dataPermissionScopeDTO;
    }

    public static DataPermissionScopeDTO createForAllPermissions(
            String id
    ) {
        DataPermissionScopeDTO dataPermissionScopeDTO = new DataPermissionScopeDTO();
        dataPermissionScopeDTO.setId(id);

        dataPermissionScopeDTO.setSearchIndexCode(DataPermissionScopeConfig.ALL_PERMISSIONS);
        dataPermissionScopeDTO.setScopes(Collections.singletonList(DataPermissionScopeConfig.ALL_PERMISSIONS));
        dataPermissionScopeDTO.setCrossPermission(true);

        return dataPermissionScopeDTO;
    }

    public static DataPermissionScopeDTO empty(String id) {
        DataPermissionScopeDTO dataPermissionScopeDTO = new DataPermissionScopeDTO();
        dataPermissionScopeDTO.setId(id);

        dataPermissionScopeDTO.setScopes(Collections.singleton(id));
        dataPermissionScopeDTO.setCrossPermission(false);

        return dataPermissionScopeDTO;
    }
}
