package com.bcxin.saas.core.components;

import java.sql.SQLException;
import java.util.function.Supplier;

public interface ThreadContextManager {
    <T> void store(String key, T instance);

    <T> T get(String key);

    <T> T get(String key, Supplier<T> supplier,Class<T> tClass);

    void clear() throws SQLException;

    void remove(String key);
    
    boolean isWebRequest();
}
