package com.bcxin.saas.core.components;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.utils.AESUtil;

public interface EncryptProvider {
    String encode(String plainText);

    String decode(String encodedText);

    static class EncryptProviderImpl implements EncryptProvider
    {
        @Override
        public String encode(String plainText) {
            try {
                return AESUtil.encode(plainText);
            } catch (Exception ex) {
                ex.printStackTrace();

                throw new SaasBadException("EncryptProviderImpl加密异常");
            }
        }

        @Override
        public String decode(String encodedText) {
            try {
                return AESUtil.decode(encodedText);
            } catch (Exception ex) {
                ex.printStackTrace();

                throw new SaasBadException("EncryptProviderImpl加密异常");
            }
        }
    }
}
