package com.bcxin.ars.startup;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.task.TaskCatalog;
import com.bcxin.ars.model.task.TaskLevel;
import com.bcxin.ars.model.task.TaskStatus;
import com.bcxin.ars.model.task.TaskType;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.task.TaskCatalogService;
import com.bcxin.ars.service.task.TaskLevelService;
import com.bcxin.ars.service.task.TaskStatusService;
import com.bcxin.ars.service.task.TaskTypeService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.ThirdPartyURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import javax.servlet.ServletContext;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class InitService {

	private static Logger logger = LoggerFactory.getLogger(InitService.class);
	public static ServletContext context;
	public static ApplicationContext appContext;

	static {
		JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
	}

	@Autowired
	private ConfigService configService;

	@Autowired
	private GuardStatusService guardStatusService;

	@Autowired
	private EduService eduService;

	@Autowired
	private SecurityProfessionLevelService proLevelService;

	@Autowired
	private StarLevelService starLevelService;

	@Autowired
	private SecurityScopeService scopeService;

	@Autowired
	private NationService nationService;

	@Autowired
	private NativeService nativeService;

	@Autowired
	private TaskTypeService taskTypeService;

	@Autowired
	private TaskCatalogService taskCatalogService;

	@Autowired
	private TaskLevelService taskLevelService;

	@Autowired
	private TaskStatusService taskStatusService;

	@Autowired
	private ModuleService moduleService;

	@Autowired
	private ConfigDao configDao;

	@Value("${upload-folder}")
	private String uploadFolder;

	@Value("${temp-folder}")
	private String tempFolder;

	public void init() {
		logger.info("init upload folder...");
		File uploadF = new File(uploadFolder);
		if(!uploadF.exists()) {
			uploadF.mkdirs();
		}

		logger.info("init temp folder...");
		File tempF = new File(tempFolder);
		if(!tempF.exists()) {
			tempF.mkdirs();
		}

		logger.info("init constants...");
		List<Config> configList = configService.findAll();
		for(Config config : configList) {
			InitService.context.setAttribute(config.getKey(), config.getValue());
			if(config.getKey().equals(Constants.CURRENT_NATIVE)) {
				logger.info("init current native...");
				InitService.context.setAttribute(Constants.CURRENT_NATIVE, config.getValue());
			} else if(config.getKey().equals(Constants.BLOOD)) {
				logger.info("init blood list...");
				String[] bloodList = config.getValue().split(Constants.SPLIT);
				InitService.context.setAttribute(Constants.BLOOD, bloodList);
			} else if(config.getKey().equals(Constants.DRIVING_LEVEL)) {
				logger.info("init driving level...");
				String[] drivingList = config.getValue().split(Constants.SPLIT);
				InitService.context.setAttribute(Constants.DRIVING_LEVEL, drivingList);
			} else if(config.getKey().equals(Constants.GENDER)) {
				logger.info("init gender...");
				String[] gender = config.getValue().split(Constants.SPLIT);
				InitService.context.setAttribute(Constants.GENDER, gender);
			} else if(config.getKey().equals("task_alert_min")) {
				logger.info("init task_alert_min...");
				Constants.TASK_ALERT_MIN = Integer.valueOf(config.getValue().trim());
			}else if(config.getKey().equals(Constants.CURRENT_PROVINCE)){
				/**
				 * 当前省份信息
				 */
				Constants.APPROVAL_KEY=config.getValue()+"00";
			}
		}

		logger.info("init edu list...");
		List<GuardStatus> guardStatusList = guardStatusService.findAll();
		InitService.context.setAttribute(Constants.GUARDSTATUS_LIST, guardStatusList);
		Map<Long, GuardStatus> guardStatusMap = guardStatusService.findMap();
		InitService.context.setAttribute(Constants.GUARDSTATUS_MAP, guardStatusMap);

		logger.info("init edu list...");
		List<Edu> eduList = eduService.findAll();
		InitService.context.setAttribute(Constants.EDU_LIST, eduList);
		Map<Long, Edu> eduMap = eduService.findMap();
		InitService.context.setAttribute(Constants.EDU_MAP, eduMap);

		logger.info("init profession level...");
		List<SecurityProfessionLevel> proLevelList = proLevelService.findAll();
		InitService.context.setAttribute(Constants.PROFESSION_LEVEL_LIST, proLevelList);
		Map<Long, SecurityProfessionLevel> proLevelMap = proLevelService.findMap();
		InitService.context.setAttribute(Constants.PROFESSION_LEVEL_MAP, proLevelMap);

		logger.info("init star level...");
		List<StarLevel> starLevelList = starLevelService.findAll();
		InitService.context.setAttribute(Constants.STAR_LEVEL_LIST, starLevelList);
		Map<Long, StarLevel> starLevelMap = starLevelService.findMap();
		InitService.context.setAttribute(Constants.STAR_LEVEL_MAP, starLevelMap);

		logger.info("init security scope list...");
		List<SecurityScope> scopeList = scopeService.findAll();
		InitService.context.setAttribute(Constants.SCOPE_LIST, scopeList);

		logger.info("init nation list...");
		List<Nation> nationList = nationService.findAll();
		InitService.context.setAttribute(Constants.NATION_LIST, nationList);

		logger.info("init native map...");
		Map<Long, List<Native>> nativeMap = nativeService.findMap();
		InitService.context.setAttribute(Constants.NATIVE_MAP, nativeMap);
		List<Native> nativeList = nativeService.findAll();
		Map<Long, Native> nativeData = new HashMap<Long, Native>();
		for(Native nat : nativeList) {
			nativeData.put(nat.getCode(), nat);
		}
		InitService.context.setAttribute(Constants.NATIVE_DATA, nativeData);

		logger.info("init task type list...");
		List<TaskType> taskTypeList = taskTypeService.findAll();
		InitService.context.setAttribute(Constants.TASK_TYPE, taskTypeList);

		logger.info("init task status list...");
		List<TaskStatus> taskStatusList = taskStatusService.findAll();
		InitService.context.setAttribute(Constants.TASK_STATUS, taskStatusList);

		logger.info("init task catalog list...");
		List<TaskCatalog> taskCatalogList = taskCatalogService.find();
		InitService.context.setAttribute(Constants.TASK_CATALOG, taskCatalogList);

		logger.info("init task level list...");
		List<TaskLevel> taskLevelList = taskLevelService.findAll();
		InitService.context.setAttribute(Constants.TASK_LEVEL, taskLevelList);

		logger.info("init module map...");
		Map<Long, Module> modulelMap = moduleService.findAll();
		InitService.context.setAttribute(Constants.MODULE_MAP, modulelMap);
		logger.info("init config...");
		//百联保地址
		Config coninsConfig = configDao.findByKey(Constants.CONINS);
		String coninsURL = "";
		if (coninsConfig != null && coninsConfig.getValue() != null) {
			coninsURL = coninsConfig.getValue();
			ThirdPartyURL.BAILIANBAO = coninsURL;
		}

		//分销地址
		Config fenxiaoConfig = configDao.findByKey(Constants.FENXIAO);
		String fenxiaoURL = "";
		if (fenxiaoConfig != null && fenxiaoConfig.getValue() != null) {
			fenxiaoURL = fenxiaoConfig.getValue();
			ThirdPartyURL.FENXIAO = fenxiaoURL;
		}


		//身份认定地址
		Config authConfig = configDao.findByKey(Constants.AUTH_URL);
		String authURL = "";
		if (authConfig != null && authConfig.getValue() != null) {
			authURL = authConfig.getValue();
			ThirdPartyURL.AUTH_URL = authURL;
		}


	}

}
