<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
	<%@include file="/WEB-INF/views/include/head.jsp"%>
	<link href="${ctxStatic }/css/plugins/bootstrap-table/bootstrap-table.min.css?v=${version}" rel="stylesheet">
</head>
<body class="gray-bg">
<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-sm-12">
			<div class="ibox float-e-margins">
				<div class="ibox-content">
					<form id="searchForm" class="form-horizontal">
						<div class="form-group">
							<label class="col-sm-1 control-label">姓名</label>
							<div class="col-sm-2">
								<input type="text" class="form-control" id="name" name="name">
							</div>
							<label class="col-sm-1 control-label">身份证号</label>
							<div class="col-sm-2">
								<input type="text" class="form-control" id="cardnumber" name="cardnumber">
							</div>
							<label class="col-sm-1 control-label">审批状态</label>
							<div class="col-sm-2">
								<select class="form-control m-b"  id="approvalstate" name="approvalstate">
									<option value="">--请选择--</option>
									<option value="004">审批不通过</option>
									<option value="003">审批通过</option>
									<option value="005">审批中</option>
									<option value="002">待审批</option>
								</select>
							</div>
							<div class="col-sm-2">
								<button class="btn btn-primary" type="button" onclick="reSearch();">搜索</button>
								<button class="btn btn-primary" type="button" onclick="bjsc();">背景核查</button>
								<button class="btn btn-primary" type="button" onclick="bjscrk();">人口核查</button>
								<button class="btn btn-primary" type="button" onclick="personImg();">人口库照片</button>
								<button class="btn btn-primary" type="button" onclick="sxPerson();">人员查询</button>


								<button class="btn btn-primary" type="button" onclick="bjPerson();">人员</button>
								<button class="btn btn-primary" type="button" onclick="mPerson();">上报部级接口</button>


								<button class="btn btn-primary" type="button" onclick="bjRest();">公司</button>
								<button class="btn btn-primary" type="button" onclick="bjImg();">照片</button>
								<button class="btn btn-primary" type="button" onclick="beijingCheckPerson();">北京核查库查询</button>

							</div>
						</div>
					</form>
						<div class="btn-group hidden-xs" id="tableEventsToolbar" role="group">
							<c:if test="${police eq '0' and isAdmin eq '1' }">
								<a href="<c:url value='/manage/personcertificate/generateSubsidyRoster.json?sid=${sid}'/>" target="ajaxTodo" title="补充生成花名册?" class="btn btn-primary">
									补充生成花名册
								</a>
							</c:if>
							<c:if test="${police eq '1' and isAdmin eq '1' }">
								<a href="<c:url value='/manage/personcertificate/batch/3.do?sid=${sid}'/>" target="dialog" width="960px" height="600px" class="btn btn-primary">批量获取指纹</a>
								<c:if test="${is_need_activitt eq 1 }">
									<a href="<c:url value='/manage/personcertificate/batch/1.do?sid=${sid}'/>" target="dialog" width="960px" height="600px" class="btn btn-primary">批量重置流程</a>
									<a href="<c:url value='/manage/personcertificate/batch/2.do?sid=${sid}'/>" target="dialog" width="960px" height="600px" class="btn btn-primary">批量重启流程</a>
								</c:if>
							</c:if>
						</div>
					<table id="defaultTable">
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
<%@include file="/WEB-INF/views/include/foot.jsp"%>
<script src="${ctxStatic }/js/plugins/bootstrap-table/bootstrap-table.min.js?v=${version}"></script>
<script src="${ctxStatic }/js/plugins/bootstrap-table/locale/bootstrap-table-zh-CN.min.js?v=${version}"></script>
<script src="${ctxStatic }/js/tablePage.js?v=${version}"></script>
<script>
	/**
	 * 北京核查库查询
	 */
	function beijingCheckPerson() {
		var cardnumber = $("#cardnumber").val();
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/checkPersonBaseInfo.do",
			dataType : "json",
			data :{"beQueriedPeopleIdCardNumber":cardnumber},
			success : function(json) {
                alert(json);
				console.log(json);
				layer.close(loadIndex);
			},error: function(err){
				console.log(err);
				layer.close(loadIndex);
			}
		});
	}

	/****
	 * 背景核查
	 */
	function bjsc(){
		var cardnumber = $("#cardnumber").val();
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/bjsc.do",
			dataType : "json",
			data :{"cardnumber":cardnumber},
			success : function(json) {
				layer.close(loadIndex);
				alert(json.data);
			},error: function(xhr, ajaxOptions, thrownError){
				layer.close(loadIndex);
				ajaxError(xhr, ajaxOptions, thrownError);
			}
		});
	}

	/****
	 * 部级人员
	 */
	function bjPerson(){
		var cardnumber = $("#cardnumber").val();
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/bjPerson.do",
			dataType : "json",
			data :{"cardnumber":cardnumber},
			success : function(json) {
				layer.close(loadIndex);
				alert(json.data);
			},error: function(xhr, ajaxOptions, thrownError){
				layer.close(loadIndex);
				ajaxError(xhr, ajaxOptions, thrownError);
			}
		});
	}
	function mPerson(){
		var idnum = $("#cardnumber").val();
		if(idnum ==""){
			toastrError("请输入身份证！")
			return ;
		}
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/mPerson.do",
			dataType : "json",
			data :{"idnum":idnum},
			success : function(json) {
				layer.close(loadIndex);
				alert(json.data);
			},error: function(xhr, ajaxOptions, thrownError){
				layer.close(loadIndex);
				ajaxError(xhr, ajaxOptions, thrownError);
			}
		});
	}
	/****
	 * 部级人员
	 */
	function bjRest(){
		var cardnumber = $("#cardnumber").val();
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/bjRest.do",
			dataType : "json",
			data :{"cardnumber":cardnumber},
			success : function(json) {
				layer.close(loadIndex);
				alert(json.data);
			},error: function(xhr, ajaxOptions, thrownError){
				layer.close(loadIndex);
				ajaxError(xhr, ajaxOptions, thrownError);
			}
		});
	}
	/****
	 * 部级人员
	 */
	function bjImg(){
		var cardnumber = $("#cardnumber").val();
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/bjImg.do",
			dataType : "json",
			data :{"cardnumber":cardnumber},
			success : function(json) {
				layer.close(loadIndex);
				alert(json.data);
			},error: function(xhr, ajaxOptions, thrownError){
				layer.close(loadIndex);
				ajaxError(xhr, ajaxOptions, thrownError);
			}
		});
	}
	/****
	 * 人口库照片
	 */
	function sxPerson(){
		var cardnumber = $("#cardnumber").val();
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/sxPerson.do",
			dataType : "json",
			data :{"cardnumber":cardnumber},
			success : function(json) {
				layer.close(loadIndex);
				alert(json.data);
			},error: function(xhr, ajaxOptions, thrownError){
				layer.close(loadIndex);
				ajaxError(xhr, ajaxOptions, thrownError);
			}
		});
	}
	/****
	 * 人口库照片
	 */
	function personImg(){
		var cardnumber = $("#cardnumber").val();
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/personImg.do",
			dataType : "json",
			data :{"cardnumber":cardnumber},
			success : function(json) {
				layer.close(loadIndex);
				console.log(json);
				if(json.successful){
                    toastrSuccess(json.msg);
                    layer.open({
                        type: 1,
                        content: '<img src="data:image/jpeg;base64,'+json.data.photo+'" width="200" height="200">' //这里content是一个普通的String
                    });
				}else{
                    toastrError(json.msg);
				}
			},error: function(xhr, ajaxOptions, thrownError){
				layer.close(loadIndex);
				ajaxError(xhr, ajaxOptions, thrownError);
			}
		});
	}
	/***
	 * 人口核查
	 */
	function bjscrk(){
		var cardnumber = $("#cardnumber").val();
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/bjscrk.do",
			dataType : "json",
			data :{"cardnumber":cardnumber},
			success : function(json) {
				layer.close(loadIndex);
				alert(json.data);
			},error: function(xhr, ajaxOptions, thrownError){
				layer.close(loadIndex);
				ajaxError(xhr, ajaxOptions, thrownError);
			}
		});
	}


    $(function(){
        var objId = "defaultTable";
        var url = ctx + "/manage/personcertificate/searchList.json?sid=${sid}";
        var columns = [
            {title: 'id',field: 'id', visible: false, align: 'center',valign: 'middle'},
            {title: '姓名',field: 'name',align: 'center',valign: 'middle'},
            {title: '身份证号',field: 'cardnumber',align: 'center',valign: 'middle'},
            {title: '报名公司',field: 'sc_name',align: 'center',valign: 'middle'},
            {title: '报名日期',field: 'createTime',align: 'center',valign: 'middle'},
            {title: '背景筛查',field: 'censorStatus', align: 'center',valign: 'middle',
                formatter:function(value,row,index){
                    var result = "";
                    if(row.censorStatus == '001'){
                        result = "未审查";
                    }else if(row.censorStatus == '003'){
                        result = "正常";
                    }else if(row.censorStatus == '004'){
                        result = "关注";
                    }
                    return result;
                }
			},
            {title: '指纹状态',field: 'fingercardState', align: 'center',valign: 'middle',
                formatter:function(value,row,index){
                    return row.fingercardState == '1' ? "已入库" :(row.fingercardState == '2'?"已采集":"待采集") ;
                }
			},
            {title: '指纹卡号',field: 'fingerprint', align: 'center',valign: 'middle'},
            {title: '缴费状态',field: 'feeState', align: 'center',valign: 'middle',
                formatter:function(value,row,index){
                    return row.feeState == '1' ? "已缴费" : "未缴费";
                }
            },
            {title: '考试结果',field: 'testState', align: 'center',valign: 'middle',
                formatter:function(value,row,index){
					if(row.testState){
						return row.testState == '1' ? "已通过" : "未通过";
					}else{
					    return null;
					}
                }
            },
            {title: '审批状态',field: 'approvalstate',align: 'center',valign: 'middle',
                formatter:function(value,row,index){
                    //审核状态
                    var armtrainorgHtml = "";
                    if (row.approvalstate == "001") {
                        armtrainorgHtml = '未提交';//审核状态
                    } else if (row.approvalstate == "002") {
                        armtrainorgHtml = '待审批';//审核状态
                    } else if (row.approvalstate == "003") {
                        armtrainorgHtml = '审批通过';//审核状态
                    } else if (row.approvalstate == "004") {
                        armtrainorgHtml = '审批不通过';//审核状态
                    } else if (row.approvalstate == "005") {
                        armtrainorgHtml = '审批中';//审核状态
                    } else if (row.approvalstate == "006") {
                        armtrainorgHtml = '待批复';//审核状态
                    } else if (row.approvalstate == "008") {
                        armtrainorgHtml = '上传批复材料';//审核状态
                    } else if (row.approvalstate == "010") {
                        armtrainorgHtml = '许可';//审核状态
                    } else if (row.approvalstate == "011") {
                        armtrainorgHtml = '不许可';//审核状态
                    } else if (row.approvalstate == "012") {
                        armtrainorgHtml = '整改';//审核状态
                    } else if (row.approvalstate == "007") {
                        armtrainorgHtml = '上传补全材料';//审核状态
                    } else {
                        armtrainorgHtml = '';//审核状态
                    }

                    return armtrainorgHtml;
                }
            },
            {title: '操作',field: '#',align: 'center',
                formatter:function(value,row,index){
                    var d = '';
                    d = d + '<a class="ml-10 btn btn-primary" href="' + ctx + '/manage/personcertificate/upload/' + row.cardnumber + '.do?sid='+sid+'" target="dialogDetail" width="960px" height="600px">上传头像</a>';
					d = d + '<a class="ml-10 btn btn-primary" href="javascript:void(0);" onclick="getZW(\''+ row.cardnumber+'\')" >获取人口库指纹</a>';
					d = d + '<a class="ml-10 btn btn-primary" href="javascript:void(0);" onclick="getZWClient(\''+ row.cardnumber+'\')" >webservice</a>';
                    d = d + '<a class="ml-10 btn btn-primary" href="'+ctx+'/manage/personcertificate/censorStatus/'+row.id+'.json?sid='+sid+'" target="ajaxTodo" title="确定查看最新背筛？">查看最新背筛</a>';
                    if(row.censorStatus != '003' && row.censorStatus != '004'){
                        d = d + '<a class="ml-10 btn btn-primary" href="'+ctx+'/manage/personcertificate/bgScreen/'+row.id+'.json?sid='+sid+'" target="ajaxTodo" title="确定背景筛查？">背景筛查</a>';
                    }
                    return d;
                }
            }
        ];
        bootstrapTableDiy(objId,url,columns);

        initLayerBtnClick();
    });

	/****
	 * 获取指纹
	 * @param cardnumber 身份证号
	 */
	function getZWClient(cardnumber) {
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/getZWClient.do",
			dataType : "json",
			data :{"cardnumber":cardnumber},
			success : function(json) {
				layer.close(loadIndex);
				alert(json.data);
			},error: function(xhr, ajaxOptions, thrownError){
				layer.close(loadIndex);
				ajaxError(xhr, ajaxOptions, thrownError);
			}
		});
	}
	/****
	 * 获取指纹
	 * @param cardnumber 身份证号
	 */
	function getZW(cardnumber) {
		var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : ctx +"/manage/personcertificate/getZW.do",
			dataType : "json",
			data :{"cardnumber":cardnumber},
			success : function(json) {
				layer.close(loadIndex);
				alert(json.data);
			},error: function(xhr, ajaxOptions, thrownError){
				layer.close(loadIndex);
				ajaxError(xhr, ajaxOptions, thrownError);
			}
		});
	}
</script>
</body>
</html>
