<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
	<title>ARS后台管理系统- 登录</title>
	<%@include file="/WEB-INF/views/include/head.jsp"%>
    <script>if(window.top !== window.self){ window.top.location = window.location;}</script>
</head>

<body class="gray-bg">

    <div class="middle-box text-center loginscreen  animated fadeInDown">
        <div>
            <div>
                <h1 class="logo-name">ARS</h1>
            </div>
            <h3>欢迎使用后台管理系统</h3>
            <form class="m-t" id="login-form">
                <div class="form-group">
                    <input type="text" name="username" size="20" class="form-control" required="required" placeholder="用户名" />
                </div>
                <div class="form-group">
                    <input type="password" name="password" size="20" class="form-control" required="required" placeholder="密码" />
                </div>
                <button type="button" onclick="login()" class="btn btn-primary block full-width m-b">登 录</button>
            </form>
        </div>
    </div>
	<%@include file="/WEB-INF/views/include/foot.jsp"%>
</body>
<script type="text/javascript">

    $(document).keyup(function(event) {
        if (event.keyCode == 13) {
            login();
        }
    });

    function login(){
        var loadIndex = parent.layer.load(0, {shade: [0.3,'#808080']});
        var formData = $('#login-form').serializeArray();
        var ajaxUrl = ctx + '/manage/user/login.do'
        $.ajax({
            url: ajaxUrl,
            type: 'post',
            dataType: 'json',
            data: formData,
            success: function (data) {
                if (data.successful) {
                    window.location = ctx + "/manage/index.do?sid="+data.data.sessionId;
                } else {
                    parent.layer.close(loadIndex);
                    toastrError(data.msg);
                }
            },
            error: function () {
                parent.layer.close(loadIndex);
                toastrError("请求发生错误!");
            }
        });
    }



</script>
</html>
